/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.loot;

import artifacts.common.config.ModConfig;
import artifacts.common.init.ModLootConditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;

public class ConfigurableRandomChance
implements ILootCondition {
    private final float defaultProbability;

    private ConfigurableRandomChance(float defaultProbability) {
        this.defaultProbability = defaultProbability;
    }

    public LootConditionType func_230419_b_() {
        return ModLootConditions.CONFIGURABLE_ARTIFACT_CHANCE;
    }

    public boolean test(LootContext context) {
        if ((Double)ModConfig.common.artifactRarity.get() >= 9999.0) {
            return false;
        }
        float c = (float)((Double)ModConfig.common.artifactRarity.get()).doubleValue();
        float p = this.defaultProbability;
        return context.func_216032_b().nextFloat() < p / (p + c - c * p);
    }

    public static ILootCondition.IBuilder configurableRandomChance(float probability) {
        return () -> new ConfigurableRandomChance(probability);
    }

    public static class Serializer
    implements ILootSerializer<ConfigurableRandomChance> {
        public void serialize(JsonObject object, ConfigurableRandomChance condition, JsonSerializationContext context) {
            object.addProperty("default_probability", (Number)Float.valueOf(condition.defaultProbability));
        }

        public ConfigurableRandomChance deserialize(JsonObject object, JsonDeserializationContext context) {
            return new ConfigurableRandomChance(JSONUtils.func_151217_k((JsonObject)object, (String)"default_probability"));
        }
    }
}

