/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config.item.curio.belt;

import artifacts.common.config.item.ItemConfig;
import artifacts.common.init.ModItems;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class AntidoteVesselConfig
extends ItemConfig {
    public Set<Effect> negativeEffects = Collections.emptySet();
    private ForgeConfigSpec.ConfigValue<List<String>> negativeEffectsValue;
    public ForgeConfigSpec.IntValue maxEffectDuration;

    public AntidoteVesselConfig(ForgeConfigSpec.Builder builder) {
        super(builder, ModItems.ANTIDOTE_VESSEL, "Affects how many times a negative effect can be shortened before breaking");
    }

    @Override
    public void addConfigs(ForgeConfigSpec.Builder builder) {
        this.negativeEffectsValue = builder.comment("List of negative effects that can be cancelled by the antidote vessel").translation(this.translate("negative_effects")).define("negative_effects", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:slowness", "minecraft:mining_fatigue", "minecraft:nausea", "minecraft:blindness", "minecraft:hunger", "minecraft:weakness", "minecraft:poison", "minecraft:wither", "minecraft:levitation"}));
        this.maxEffectDuration = builder.worldRestart().comment("The maximum duration (in ticks) a negative effect can last with the antidote vessel equipped").translation(this.translate("max_effect_duration")).defineInRange("max_effect_duration", 120, 0, Integer.MAX_VALUE);
    }

    @Override
    public void bake() {
        this.negativeEffects = ((List)this.negativeEffectsValue.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.POTIONS).getValue(arg_0)).collect(Collectors.toSet());
    }
}

