/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.capability.killtracker;

import artifacts.common.capability.killtracker.EntityKillTracker;
import artifacts.common.capability.killtracker.EntityKillTrackerProvider;
import artifacts.common.capability.killtracker.IEntityKillTracker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityKillTrackerCapability {
    @CapabilityInject(value=IEntityKillTracker.class)
    public static Capability<IEntityKillTracker> INSTANCE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IEntityKillTracker.class, (Capability.IStorage)new Storage(), EntityKillTracker::new);
    }

    @Mod.EventBusSubscriber(modid="artifacts")
    public static class CapabilityEventHandler {
        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                EntityKillTrackerProvider provider = new EntityKillTrackerProvider();
                event.addCapability(new ResourceLocation("artifacts", "entity_kill_tracker"), (ICapabilityProvider)provider);
                event.addListener(provider::invalidate);
            }
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
                player.getCapability(INSTANCE).ifPresent(tracker -> tracker.addEntityType(event.getEntityLiving().func_200600_R()));
            }
        }
    }

    public static class Storage
    implements Capability.IStorage<IEntityKillTracker> {
        public INBT writeNBT(Capability<IEntityKillTracker> capability, IEntityKillTracker instance, Direction side) {
            ListNBT list = new ListNBT();
            for (EntityType<?> type : instance.getEntityTypes()) {
                list.add((Object)StringNBT.func_229705_a_((String)type.getRegistryName().toString()));
            }
            return list;
        }

        public void readNBT(Capability<IEntityKillTracker> capability, IEntityKillTracker instance, Direction side, INBT nbt) {
            instance.clear();
            for (INBT type : (ListNBT)nbt) {
                ResourceLocation entityType = new ResourceLocation(type.func_150285_a_());
                if (!ForgeRegistries.ENTITIES.containsKey(entityType)) continue;
                instance.addEntityType((EntityType)ForgeRegistries.ENTITIES.getValue(entityType));
            }
        }
    }
}

