/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.curio.model;

import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class BeltModel
extends BipedModel<LivingEntity> {
    protected final ModelRenderer charm = new ModelRenderer((Model)this);
    private final float xOffset;
    private final float zOffset;
    private final float rotation;

    protected BeltModel(Function<ResourceLocation, RenderType> renderType, float xOffset, float zOffset, float rotation) {
        super(renderType, 0.5f, 0.0f, 32, 32);
        this.xOffset = xOffset;
        this.zOffset = zOffset;
        this.rotation = rotation;
        this.func_178719_a(false);
        this.field_78115_e = new ModelRenderer((Model)this);
        this.field_78115_e.func_78784_a(0, 0);
        this.field_78115_e.func_228301_a_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, 0.5f);
        this.field_78115_e.func_78792_a(this.charm);
    }

    public void setCharmPosition(int slot) {
        float xOffset = slot % 2 == 0 ? this.xOffset : -this.xOffset;
        float zOffset = slot % 4 < 2 ? this.zOffset : -this.zOffset;
        this.charm.func_78793_a(xOffset, 9.0f, zOffset);
        float rotation = slot % 4 < 2 ? 0.0f : (float)(-Math.PI);
        this.charm.field_78796_g = rotation += slot % 2 == 0 ^ slot % 4 >= 2 ? this.rotation : -this.rotation;
    }

    private static BeltModel belt(float xOffset, float zOffset, float rotation) {
        return BeltModel.belt(RenderType::func_228640_c_, xOffset, zOffset, rotation);
    }

    private static BeltModel belt(Function<ResourceLocation, RenderType> renderType, float xOffset, float zOffset, float rotation) {
        return new BeltModel(renderType, xOffset, zOffset, rotation);
    }

    public static BeltModel antidoteVessel() {
        BeltModel model = BeltModel.belt(4.0f, -3.0f, -0.5f);
        model.charm.func_78784_a(0, 16);
        model.charm.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f);
        model.charm.func_78784_a(0, 26);
        model.charm.func_228300_a_(-1.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f);
        return model;
    }

    public static BeltModel cloudInABottle() {
        return new BeltModel(RenderType::func_228644_e_, 3.0f, -3.0f, -0.5f){
            private final ModelRenderer cloud;
            {
                this.charm.func_78784_a(0, 16);
                this.charm.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f);
                this.charm.func_78784_a(0, 25);
                this.charm.func_228300_a_(-1.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f);
                this.cloud = new ModelRenderer((Model)this).func_78784_a(8, 25);
                this.cloud.func_228300_a_(-1.0f, 1.5f, -1.0f, 2.0f, 2.0f, 2.0f);
                this.charm.func_78792_a(this.cloud);
            }

            public void func_225597_a_(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                super.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                this.cloud.field_78796_g = ageInTicks / 50.0f;
                this.cloud.field_78797_d = MathHelper.func_76134_b((float)(ageInTicks / 30.0f)) / 2.0f;
            }
        };
    }

    public static BeltModel crystalHeart() {
        BeltModel model = BeltModel.belt(RenderType::func_228644_e_, 2.5f, -3.01f, 0.0f);
        model.charm.func_78784_a(0, 16);
        model.charm.func_228300_a_(-2.5f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f);
        model.charm.func_78784_a(6, 16);
        model.charm.func_228300_a_(0.5f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f);
        model.charm.func_78784_a(0, 20);
        model.charm.func_228300_a_(-0.5f, 1.0f, 0.0f, 1.0f, 4.0f, 1.0f);
        model.charm.func_78784_a(4, 20);
        model.charm.func_228300_a_(-1.5f, 3.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        model.charm.func_78784_a(8, 20);
        model.charm.func_228300_a_(0.5f, 3.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return model;
    }

    public static BipedModel<LivingEntity> heliumFlamingo() {
        BipedModel model = new BipedModel(RenderType::func_228640_c_, 0.0f, 0.0f, 64, 64);
        model.func_178719_a(false);
        model.field_78115_e = new ModelRenderer((Model)model);
        model.field_78115_e.func_78784_a(16, 36).func_228300_a_(-1.0f, 1.0f, -14.0f, 2.0f, 3.0f, 5.0f);
        model.field_78115_e.func_78784_a(0, 18).func_228300_a_(4.0f, 9.0f, -7.0f, 4.0f, 4.0f, 14.0f);
        model.field_78115_e.func_78784_a(0, 0).func_228300_a_(-8.0f, 9.0f, -7.0f, 4.0f, 4.0f, 14.0f);
        model.field_78115_e.func_78784_a(36, 0).func_228300_a_(-4.0f, 9.0f, 3.0f, 8.0f, 4.0f, 4.0f);
        model.field_78115_e.func_78784_a(36, 8).func_228300_a_(-4.0f, 9.0f, -7.0f, 8.0f, 4.0f, 4.0f);
        model.field_78115_e.func_78784_a(0, 36).func_228300_a_(-2.0f, 1.0f, -9.0f, 4.0f, 11.0f, 4.0f);
        return model;
    }

    public static BeltModel obsidianSkull() {
        BeltModel model = BeltModel.belt(4.5f, -4.0f, -0.5f);
        model.charm.func_78784_a(0, 16);
        model.charm.func_228300_a_(-2.5f, 0.0f, 0.0f, 5.0f, 3.0f, 4.0f);
        model.charm.func_78784_a(18, 16);
        model.charm.func_228300_a_(-1.5f, 3.0f, 0.0f, 1.0f, 1.0f, 2.0f);
        model.charm.func_78784_a(18, 19);
        model.charm.func_228300_a_(0.5f, 3.0f, 0.0f, 1.0f, 1.0f, 2.0f);
        return model;
    }

    public static BeltModel universalAttractor() {
        BeltModel model = BeltModel.belt(2.5f, -3.0f, 0.0f);
        model.charm.func_78784_a(0, 16);
        model.charm.func_228300_a_(-2.5f, 0.0f, 0.0f, 5.0f, 2.0f, 1.0f);
        model.charm.func_78784_a(0, 19);
        model.charm.func_228300_a_(-2.5f, 2.0f, 0.0f, 2.0f, 4.0f, 1.0f);
        model.charm.func_78784_a(6, 19);
        model.charm.func_228300_a_(0.5f, 2.0f, 0.0f, 2.0f, 4.0f, 1.0f);
        return model;
    }
}

