/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectFell
extends AbstractEffect {
    public static EffectFell INSTANCE = new EffectFell();
    public static ITag.INamedTag<Block> FELLABLE = BlockTags.createOptional((ResourceLocation)new ResourceLocation("ars_nouveau", "harvest/fellable"));
    public ForgeConfigSpec.IntValue AOE_BONUS;

    private EffectFell() {
        super("fell", "Fell");
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult ray, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        BlockPos blockPos = ray.func_216350_a();
        BlockState state = world.func_180495_p(blockPos);
        if (this.isTree(state)) {
            Set<BlockPos> list = this.getTree(world, blockPos, (Integer)this.GENERIC_INT.get() + (Integer)this.AOE_BONUS.get() * spellStats.getBuffCount(AugmentAOE.INSTANCE));
            world.func_217379_c(2001, blockPos, Block.func_196246_j((BlockState)state));
            list.forEach(listPos -> {
                if (!BlockUtil.destroyRespectsClaim(shooter, world, listPos)) {
                    return;
                }
                if (spellStats.hasBuff(AugmentExtract.INSTANCE)) {
                    world.func_180495_p(listPos).func_215693_a(LootUtil.getSilkContext((ServerWorld)world, listPos, shooter)).forEach(i -> world.func_217376_c((Entity)new ItemEntity(world, (double)listPos.func_177958_n(), (double)listPos.func_177956_o(), (double)listPos.func_177952_p(), i)));
                    BlockUtil.destroyBlockSafelyWithoutSound(world, listPos, false);
                } else if (spellStats.hasBuff(AugmentFortune.INSTANCE)) {
                    world.func_180495_p(listPos).func_215693_a(LootUtil.getFortuneContext((ServerWorld)world, listPos, shooter, spellStats.getBuffCount(AugmentFortune.INSTANCE))).forEach(i -> world.func_217376_c((Entity)new ItemEntity(world, (double)listPos.func_177958_n(), (double)listPos.func_177956_o(), (double)listPos.func_177952_p(), i)));
                    BlockUtil.destroyBlockSafelyWithoutSound(world, listPos, false);
                } else {
                    BlockUtil.destroyBlockSafelyWithoutSound(world, listPos, true);
                }
            });
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericInt(builder, 50, "Base amount of harvested blocks", "base_harvest");
        this.AOE_BONUS = builder.comment("Additional max blocks per AOE").defineInRange("aoe_bonus", 50, 0, Integer.MAX_VALUE);
    }

    public boolean isTree(BlockState blockstate) {
        return blockstate.func_177230_c().func_203417_a(FELLABLE);
    }

    public Set<BlockPos> getTree(World world, BlockPos start, int maxBlocks) {
        return SpellUtil.DFSBlockstates(world, start, maxBlocks, this::isTree);
    }

    @Override
    public int getManaCost() {
        return 150;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_151056_x;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE, AugmentExtract.INSTANCE, AugmentFortune.INSTANCE, AugmentAmplify.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Harvests entire trees, mushrooms, cactus, and other vegetation. Can be amplified with Amplify to break materials of higher hardness. AOE will increase the number of blocks that may be broken at one time.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_EARTH);
    }
}

