/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.RitualContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.RitualTile;
import com.hollingsworth.arsnouveau.common.entity.EntityRitualProjectile;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public class RitualDig
extends AbstractRitual {
    public RitualDig() {
    }

    public RitualDig(RitualTile tile, RitualContext context) {
        super(tile, context);
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.tile == null) {
            return;
        }
        EntityRitualProjectile ritualProjectile = new EntityRitualProjectile(this.getWorld(), this.getPos().func_177984_a());
        ritualProjectile.func_70107_b(ritualProjectile.func_226277_ct_() + 0.5, ritualProjectile.func_226278_cu_(), ritualProjectile.func_226281_cx_() + 0.5);
        ritualProjectile.tilePos = this.getPos();
        this.getWorld().func_217376_c((Entity)ritualProjectile);
    }

    public boolean canBlockBeHarvested(BlockPos pos) {
        return this.getWorld().func_180495_p(pos).func_185887_b((IBlockReader)this.getWorld(), pos) >= 0.0f && 5 >= this.getWorld().func_180495_p(pos).getHarvestLevel();
    }

    public void breakBlock(BlockPos pos) {
        if (!this.canBlockBeHarvested(pos) || !BlockUtil.destroyRespectsClaim((LivingEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.getWorld())), this.getWorld(), pos)) {
            return;
        }
        BlockState state = this.getWorld().func_180495_p(pos);
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151046_w);
        state.func_177230_c().func_180657_a(this.getWorld(), (PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.getWorld())), pos, this.getWorld().func_180495_p(pos), this.getWorld().func_175625_s(pos), stack);
        BlockUtil.destroyBlockSafely(this.getWorld(), pos, false, (LivingEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.getWorld())));
    }

    @Override
    public void tick() {
        World world = this.tile.func_145831_w();
        if (world.func_82737_E() % 20L == 0L && !world.field_72995_K) {
            BlockPos pos = this.tile.func_174877_v().func_177978_c().func_177979_c(this.getContext().progress);
            if (pos.func_177956_o() < 1) {
                this.onEnd();
                return;
            }
            this.breakBlock(pos);
            this.breakBlock(pos.func_177968_d().func_177968_d());
            this.breakBlock(pos.func_177968_d().func_177974_f());
            this.breakBlock(pos.func_177968_d().func_177976_e());
            ++this.getContext().progress;
        }
    }

    @Override
    public ParticleColor getCenterColor() {
        return new ParticleColor(this.rand.nextInt(50), this.rand.nextInt(255), this.rand.nextInt(20));
    }

    @Override
    public String getID() {
        return "burrowing";
    }

    @Override
    public String getLangDescription() {
        return "Digs four adjacent holes to bedrock, dropping any blocks.";
    }

    @Override
    public String getLangName() {
        return "Burrowing";
    }
}

