/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketANEffect {
    private final EffectType type;
    private final double x;
    private final double y;
    private final double z;
    private final int red;
    private final int green;
    private final int blue;
    private final int[] args;

    public PacketANEffect(EffectType type, double x, double y, double z, int ... args) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.red = 255;
        this.green = 25;
        this.blue = 180;
        this.args = args;
    }

    public PacketANEffect(EffectType type, double x, double y, double z, ParticleColor.IntWrapper wrapper, int ... args) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.red = wrapper.r;
        this.blue = wrapper.b;
        this.green = wrapper.g;
        this.args = args;
    }

    public PacketANEffect(EffectType type, BlockPos pos, int ... args) {
        this(type, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), args);
    }

    public PacketANEffect(EffectType type, BlockPos pos, ParticleColor.IntWrapper wrapper, int ... args) {
        this(type, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), wrapper, args);
    }

    public static PacketANEffect decode(PacketBuffer buf) {
        EffectType type = EffectType.values()[buf.readByte()];
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        int red = buf.readInt();
        int green = buf.readInt();
        int blue = buf.readInt();
        int[] args = new int[type.argCount];
        for (int i = 0; i < args.length; ++i) {
            args[i] = buf.func_150792_a();
        }
        return new PacketANEffect(type, x, y, z, new ParticleColor.IntWrapper(red, green, blue), args);
    }

    public static void encode(PacketANEffect msg, PacketBuffer buf) {
        buf.writeByte(msg.type.ordinal());
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.writeInt(msg.red);
        buf.writeInt(msg.green);
        buf.writeInt(msg.blue);
        for (int i = 0; i < msg.type.argCount; ++i) {
            buf.func_150787_b(msg.args[i]);
        }
    }

    public static enum EffectType {
        TIMED_GLOW(4),
        TIMED_HELIX(0),
        BURST(0);

        private final int argCount;

        private EffectType(int argCount) {
            this.argCount = argCount;
        }
    }

    public static class Handler {
        public static void handle(final PacketANEffect message, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                ctx.get().setPacketHandled(true);
                return;
            }
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.func_71410_x();
                    ClientWorld world = mc.field_71441_e;
                    switch (message.type) {
                        case BURST: {
                            for (int i = 0; i < 10; ++i) {
                                double d0 = message.x + 0.5;
                                double d1 = message.y + 1.2;
                                double d2 = message.z + 0.5;
                                world.func_195594_a(GlowParticleData.createData(new ParticleColor(message.red, message.green, message.blue)), d0, d1, d2, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0);
                            }
                            break;
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

