/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding;

import com.hollingsworth.arsnouveau.common.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.IStuckHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.MovementHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.Node;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathFindingStatus;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathPointExtended;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathResult;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.Pathfinding;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathingStuckHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs.AbstractPathJob;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs.PathJobMoveToPathable;
import com.hollingsworth.arsnouveau.common.util.Log;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.LadderBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class MinecoloniesAdvancedPathNavigate
extends AbstractAdvancedPathNavigate {
    private static final double ON_PATH_SPEED_MULTIPLIER = 1.3;
    public static final double MIN_Y_DISTANCE = 0.001;
    public static final int MAX_SPEED_ALLOWED = 2;
    public static final double MIN_SPEED_ALLOWED = 0.1;
    private PathResult<AbstractPathJob> pathResult;
    private long pathStartTime = 0L;
    private BlockPos spawnedPos = BlockPos.field_177992_a;
    private BlockPos desiredPos;
    private int desiredPosTimeout = 0;
    private IStuckHandler stuckHandler;
    private boolean isSneaking = true;
    private double swimSpeedFactor = 1.0;

    public MinecoloniesAdvancedPathNavigate(MobEntity entity, World world) {
        super(entity, world);
        entity.field_70765_h = new MovementHandler(entity);
        this.field_179695_a = new WalkNodeProcessor();
        this.field_179695_a.func_186317_a(true);
        this.getPathingOptions().setEnterDoors(true);
        this.field_179695_a.func_186321_b(true);
        this.getPathingOptions().setCanOpenDoors(true);
        this.field_179695_a.func_186316_c(true);
        this.getPathingOptions().setCanSwim(true);
        this.stuckHandler = PathingStuckHandler.createStuckHandler().withTakeDamageOnStuck(0.0f).withTeleportSteps(6).withTeleportOnFullStuck();
    }

    @Override
    public BlockPos getDestination() {
        return this.destination;
    }

    public PathResult setPathJob(AbstractPathJob job, BlockPos dest, double speedFactor) {
        this.func_75499_g();
        this.destination = dest;
        this.originalDestination = dest;
        if (dest != null) {
            this.desiredPos = dest;
            this.desiredPosTimeout = 1000;
        }
        this.walkSpeedFactor = speedFactor;
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            Log.getLogger().error("Tried to set a bad speed:" + speedFactor + " for entity:" + this.ourEntity, (Throwable)new Exception());
            return null;
        }
        job.setPathingOptions(this.getPathingOptions());
        this.pathResult = job.getResult();
        this.pathResult.startJob(Pathfinding.getExecutor());
        return this.pathResult;
    }

    public boolean func_75500_f() {
        return (this.pathResult == null || this.pathResult.isDone() && this.pathResult.getStatus() != PathFindingStatus.CALCULATION_COMPLETE) && super.func_75500_f();
    }

    public void func_75501_e() {
        int oldIndex;
        if (this.desiredPosTimeout > 0 && this.desiredPosTimeout-- <= 0) {
            this.desiredPos = null;
        }
        if (this.pathResult != null) {
            if (!this.pathResult.isDone()) {
                return;
            }
            if (this.pathResult.getStatus() == PathFindingStatus.CALCULATION_COMPLETE) {
                this.processCompletedCalculationResult();
            }
        }
        int n = oldIndex = this.func_75500_f() ? 0 : this.func_75505_d().func_75873_e();
        if (this.isSneaking) {
            this.isSneaking = false;
            this.field_75515_a.func_226284_e_(false);
        }
        this.ourEntity.func_70657_f(0.0f);
        if (this.handleLadders(oldIndex)) {
            this.func_75508_h();
            return;
        }
        if (this.handleRails()) {
            return;
        }
        ++this.field_75510_g;
        if (this.field_188562_p) {
            this.func_188554_j();
        }
        if (!this.func_75500_f()) {
            if (this.func_75485_k()) {
                this.func_75508_h();
            } else if (this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
                Vector3d vector3d = this.func_75502_i();
                Vector3d vector3d1 = this.field_75514_c.func_75878_a((Entity)this.field_75515_a);
                if (vector3d.field_72448_b > vector3d1.field_72448_b && !this.field_75515_a.func_233570_aj_() && MathHelper.func_76128_c((double)vector3d.field_72450_a) == MathHelper.func_76128_c((double)vector3d1.field_72450_a) && MathHelper.func_76128_c((double)vector3d.field_72449_c) == MathHelper.func_76128_c((double)vector3d1.field_72449_c)) {
                    this.field_75514_c.func_75875_a();
                }
            }
            DebugPacketSender.func_218803_a((World)this.field_75513_b, (MobEntity)this.field_75515_a, (Path)this.field_75514_c, (float)this.field_188561_o);
            if (!this.func_75500_f()) {
                Vector3d vector3d2 = this.field_75514_c.func_75878_a((Entity)this.field_75515_a);
                BlockPos blockpos = new BlockPos(vector3d2);
                this.field_75515_a.func_70605_aq().func_75642_a(vector3d2.field_72450_a, this.field_75513_b.func_180495_p(blockpos.func_177977_b()).func_196958_f() ? vector3d2.field_72448_b : MinecoloniesAdvancedPathNavigate.getSmartGroundY((IBlockReader)this.field_75513_b, blockpos), vector3d2.field_72449_c, this.field_75511_d);
            }
        }
        if (this.pathResult != null && this.func_75500_f()) {
            this.pathResult.setStatus(PathFindingStatus.COMPLETE);
            this.pathResult = null;
        }
        this.stuckHandler.checkStuck(this);
    }

    public static double getSmartGroundY(IBlockReader world, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        VoxelShape voxelshape = world.func_180495_p(blockpos).func_196952_d(world, blockpos);
        if (voxelshape.func_197766_b() || voxelshape.func_197758_c(Direction.Axis.Y) < 1.0) {
            return pos.func_177956_o();
        }
        return (double)blockpos.func_177956_o() + voxelshape.func_197758_c(Direction.Axis.Y);
    }

    @Override
    public PathResult moveToXYZ(double x, double y, double z, double speedFactor) {
        int newX = MathHelper.func_76128_c((double)x);
        int newY = (int)y;
        int newZ = MathHelper.func_76128_c((double)z);
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobMoveToLocation && (this.pathResult.isComputing() || this.destination != null && this.destination.equals((Object)new BlockPos(newX, newY, newZ)) || this.originalDestination != null && this.originalDestination.equals((Object)new BlockPos(newX, newY, newZ)))) {
            return this.pathResult;
        }
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        this.desiredPos = new BlockPos(newX, newY, newZ);
        return this.setPathJob(new PathJobMoveToLocation(this.ourEntity.field_70170_p, start, this.desiredPos, (int)this.ourEntity.func_110148_a(Attributes.field_233819_b_).func_111126_e(), (LivingEntity)this.ourEntity), this.desiredPos, speedFactor);
    }

    public PathResult moveToClosestPosition(List<BlockPos> positions, double speedFactor) {
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobMoveToLocation && (this.pathResult.isComputing() || this.destination != null && positions.contains(this.destination)) || this.originalDestination != null && positions.contains(this.originalDestination)) {
            return this.pathResult;
        }
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobMoveToPathable(this.ourEntity.field_70170_p, start, positions, (int)this.ourEntity.func_110148_a(Attributes.field_233819_b_).func_111126_e(), (LivingEntity)this.ourEntity), null, speedFactor);
    }

    @Override
    public boolean tryMoveToBlockPos(BlockPos pos, double speedFactor) {
        this.moveToXYZ(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), speedFactor);
        return true;
    }

    protected PathFinder func_179679_a(int p_179679_1_) {
        return null;
    }

    protected boolean func_75485_k() {
        return true;
    }

    protected Vector3d func_75502_i() {
        return this.ourEntity.func_213303_ch();
    }

    public Path func_179680_a(BlockPos pos, int p_179680_2_) {
        return null;
    }

    protected boolean func_75493_a(Vector3d start, Vector3d end, int sizeX, int sizeY, int sizeZ) {
        return false;
    }

    public double getSpeedFactor() {
        if (this.ourEntity.func_70090_H()) {
            this.field_75511_d = this.walkSpeedFactor * this.swimSpeedFactor;
            return this.field_75511_d;
        }
        this.field_75511_d = this.walkSpeedFactor;
        return this.walkSpeedFactor;
    }

    public void func_75489_a(double speedFactor) {
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            Log.getLogger().error("Tried to set a bad speed:" + speedFactor + " for entity:" + this.ourEntity, (Throwable)new Exception());
            return;
        }
        this.walkSpeedFactor = speedFactor;
    }

    public boolean func_75492_a(double x, double y, double z, double speedFactor) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return false;
        }
        this.moveToXYZ(x, y, z, speedFactor);
        return true;
    }

    public boolean func_75497_a(Entity entityIn, double speedFactor) {
        return this.tryMoveToBlockPos(entityIn.func_233580_cy_(), speedFactor);
    }

    protected void func_75487_m() {
    }

    public boolean func_75484_a(Path path, double speedFactor) {
        if (path == null) {
            this.func_75499_g();
            return false;
        }
        this.pathStartTime = this.field_75513_b.func_82737_E();
        return super.func_75484_a(this.convertPath(path), speedFactor);
    }

    private Path convertPath(Path path) {
        int pathLength = path.func_75874_d();
        Path tempPath = null;
        if (pathLength > 0 && !(path.func_75877_a(0) instanceof PathPointExtended)) {
            PathPointExtended[] newPoints = new PathPointExtended[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                PathPoint point = path.func_75877_a(i);
                newPoints[i] = !(point instanceof PathPointExtended) ? new PathPointExtended(new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c)) : (PathPointExtended)point;
            }
            tempPath = new Path(Arrays.asList(newPoints), path.func_224770_k(), path.func_224771_h());
            PathPointExtended finalPoint = newPoints[pathLength - 1];
            this.destination = new BlockPos(finalPoint.field_75839_a, finalPoint.field_75837_b, finalPoint.field_75838_c);
        }
        return tempPath == null ? path : tempPath;
    }

    private boolean processCompletedCalculationResult() {
        this.func_75484_a(this.pathResult.getPath(), this.getSpeedFactor());
        this.pathResult.setStatus(PathFindingStatus.IN_PROGRESS_FOLLOWING);
        return false;
    }

    private boolean handleLadders(int oldIndex) {
        if (!this.func_75500_f()) {
            PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            PathPointExtended pExNext = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 1 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 1) : null;
            for (int i = this.field_75514_c.func_75873_e(); i < Math.min(this.field_75514_c.func_75874_d(), this.field_75514_c.func_75873_e() + 3); ++i) {
                PathPointExtended nextPoints = (PathPointExtended)this.func_75505_d().func_75877_a(i);
                if (!nextPoints.isOnLadder()) continue;
                Vector3d motion = this.field_75515_a.func_213322_ci();
                double x = motion.field_72450_a < -0.1 ? -0.1 : Math.min(motion.field_72450_a, 0.1);
                double z = motion.field_72450_a < -0.1 ? -0.1 : Math.min(motion.field_72449_c, 0.1);
                this.ourEntity.func_213293_j(x, motion.field_72448_b, z);
                break;
            }
            if (pEx.isOnLadder() && pExNext != null && (pEx.field_75837_b != pExNext.field_75837_b || this.field_75515_a.func_226278_cu_() > (double)pEx.field_75837_b)) {
                return this.handlePathPointOnLadder(pEx);
            }
            if (this.ourEntity.func_70090_H()) {
                return this.handleEntityInWater(oldIndex, pEx);
            }
            if (this.field_75513_b.field_73012_v.nextInt(10) == 0) {
                this.field_75511_d = this.getSpeedFactor();
            }
        }
        return false;
    }

    private BlockPos findBlockUnderEntity(Entity parEntity) {
        int blockX = (int)Math.round(parEntity.func_226277_ct_());
        int blockY = MathHelper.func_76128_c((double)(parEntity.func_226278_cu_() - 0.2));
        int blockZ = (int)Math.round(parEntity.func_226281_cx_());
        return new BlockPos(blockX, blockY, blockZ);
    }

    private boolean handleRails() {
        if (!this.func_75500_f()) {
            PathPointExtended pExNext;
            PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            PathPointExtended pathPointExtended = pExNext = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 1 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 1) : null;
            if (pExNext != null && pEx.field_75839_a == pExNext.field_75839_a && pEx.field_75838_c == pExNext.field_75838_c) {
                PathPointExtended pathPointExtended2 = pExNext = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 2 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 2) : null;
            }
            if (pEx.isOnRails() || pEx.isRailsExit()) {
                return this.handlePathOnRails(pEx, pExNext);
            }
        }
        return false;
    }

    private boolean handlePathOnRails(PathPointExtended pEx, PathPointExtended pExNext) {
        this.spawnedPos = BlockPos.field_177992_a;
        return false;
    }

    private boolean handlePathPointOnLadder(PathPointExtended pEx) {
        Vector3d vec3 = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        BlockPos entityPos = new BlockPos(this.ourEntity.func_213303_ch());
        if (vec3.func_186679_c(this.ourEntity.func_226277_ct_(), vec3.field_72448_b, this.ourEntity.func_226281_cx_()) < Math.random() * 0.1) {
            double newSpeed = 0.3;
            switch (pEx.getLadderFacing()) {
                case NORTH: {
                    vec3 = vec3.func_72441_c(0.0, 0.0, 1.0);
                    break;
                }
                case SOUTH: {
                    vec3 = vec3.func_72441_c(0.0, 0.0, -1.0);
                    break;
                }
                case WEST: {
                    vec3 = vec3.func_72441_c(1.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    vec3 = vec3.func_72441_c(-1.0, 0.0, 0.0);
                    break;
                }
                case UP: {
                    vec3 = vec3.func_72441_c(0.0, 1.0, 0.0);
                    break;
                }
                default: {
                    newSpeed = 0.0;
                    this.field_75515_a.func_226284_e_(true);
                    this.isSneaking = true;
                }
            }
            if (newSpeed > 0.0) {
                if (!(this.field_75513_b.func_180495_p(this.ourEntity.func_233580_cy_()).func_177230_c() instanceof LadderBlock)) {
                    this.ourEntity.func_213317_d(this.ourEntity.func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
                }
                this.ourEntity.func_70605_aq().func_75642_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, newSpeed);
            } else {
                if (!this.field_75513_b.func_180495_p(entityPos.func_177977_b()).isLadder((IWorldReader)this.field_75513_b, entityPos.func_177977_b(), (LivingEntity)this.ourEntity)) {
                    return false;
                }
                this.ourEntity.func_70657_f(-0.5f);
                return true;
            }
        }
        return false;
    }

    private boolean handleEntityInWater(int oldIndex, PathPointExtended pEx) {
        int curIndex = this.func_75505_d().func_75873_e();
        if (curIndex > 0 && curIndex + 1 < this.func_75505_d().func_75874_d() && this.func_75505_d().func_75877_a((int)(curIndex - 1)).field_75837_b != pEx.field_75837_b) {
            oldIndex = curIndex + 1;
        }
        this.func_75505_d().func_75872_c(oldIndex);
        Vector3d Vector3d2 = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        Vector3d vector3d = new Vector3d(this.ourEntity.func_226277_ct_(), Vector3d2.field_72448_b, this.ourEntity.func_226281_cx_());
        if (Vector3d2.func_72436_e(vector3d) < 0.1 && Math.abs(this.ourEntity.func_226278_cu_() - Vector3d2.field_72448_b) < 0.5) {
            this.func_75505_d().func_75875_a();
            if (this.func_75500_f()) {
                return true;
            }
            Vector3d2 = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        }
        this.ourEntity.func_70605_aq().func_75642_a(Vector3d2.field_72450_a, Vector3d2.field_72448_b, Vector3d2.field_72449_c, this.getSpeedFactor());
        return false;
    }

    protected void func_75508_h() {
        Vector3d next;
        this.getSpeedFactor();
        int curNode = this.field_75514_c.func_75873_e();
        int curNodeNext = curNode + 1;
        if (curNodeNext < this.field_75514_c.func_75874_d()) {
            if (!(this.field_75514_c.func_75877_a(curNode) instanceof PathPointExtended)) {
                this.field_75514_c = this.convertPath(this.field_75514_c);
            }
            PathPointExtended pEx = (PathPointExtended)this.field_75514_c.func_75877_a(curNode);
            PathPointExtended pExNext = (PathPointExtended)this.field_75514_c.func_75877_a(curNodeNext);
            if (pEx.isOnLadder() && pEx.getLadderFacing() == Direction.DOWN && !pExNext.isOnLadder()) {
                Vector3d vec3 = this.func_75502_i();
                if (vec3.field_72448_b - (double)pEx.field_75837_b < 0.001) {
                    this.field_75514_c.func_75872_c(curNodeNext);
                }
                return;
            }
        }
        this.field_188561_o = 0.5f;
        boolean wentAhead = false;
        block0: for (int i = this.field_75514_c.func_75873_e(); i < Math.min(this.field_75514_c.func_75874_d(), this.field_75514_c.func_75873_e() + 4); ++i) {
            next = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, i);
            if (!(Math.abs(this.field_75515_a.func_226277_ct_() - next.field_72450_a) < (double)this.field_188561_o - Math.abs(this.field_75515_a.func_226278_cu_() - next.field_72448_b) * 0.1) || !(Math.abs(this.field_75515_a.func_226281_cx_() - next.field_72449_c) < (double)this.field_188561_o - Math.abs(this.field_75515_a.func_226278_cu_() - next.field_72448_b) * 0.1) || !(Math.abs(this.field_75515_a.func_226278_cu_() - next.field_72448_b) < 1.0)) continue;
            this.field_75514_c.func_75875_a();
            wentAhead = true;
            if (AbstractPathJob.lastDebugNodesPath == null) continue;
            PathPoint point = this.field_75514_c.func_75877_a(i);
            BlockPos pos = new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c);
            for (Node node : AbstractPathJob.lastDebugNodesPath) {
                if (node.isReachedByWorker() || !node.pos.equals((Object)pos)) continue;
                node.setReachedByWorker(true);
                continue block0;
            }
        }
        if (this.field_75514_c.func_75879_b()) {
            this.onPathFinish();
            return;
        }
        if (wentAhead) {
            return;
        }
        if (curNode >= this.field_75514_c.func_75874_d() || curNode <= 1) {
            return;
        }
        Vector3d curr = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, curNode - 1);
        next = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, curNode);
        if (this.field_75515_a.func_213303_ch().func_72438_d(curr) >= 2.0 && this.field_75515_a.func_213303_ch().func_72438_d(next) >= 2.0) {
            block2: for (int currentIndex = curNode - 1; currentIndex > 0; --currentIndex) {
                Vector3d tempoPos = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, currentIndex);
                if (this.field_75515_a.func_213303_ch().func_72438_d(tempoPos) <= 1.0) {
                    this.field_75514_c.func_75872_c(currentIndex);
                    continue;
                }
                if (AbstractPathJob.lastDebugNodesPath == null) continue;
                BlockPos pos = new BlockPos(tempoPos.field_72450_a, tempoPos.field_72448_b, tempoPos.field_72449_c);
                for (Node node : AbstractPathJob.lastDebugNodesPath) {
                    if (!node.isReachedByWorker() || !node.pos.equals((Object)pos)) continue;
                    node.setReachedByWorker(false);
                    continue block2;
                }
            }
        }
    }

    private void onPathFinish() {
        this.func_75499_g();
    }

    public void func_188554_j() {
    }

    protected void func_179677_a(Vector3d positionVec3) {
    }

    public void func_75499_g() {
        if (this.pathResult != null) {
            this.pathResult.cancel();
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
            this.pathResult = null;
        }
        this.destination = null;
        super.func_75499_g();
    }

    public void func_212239_d(boolean canSwim) {
        super.func_212239_d(canSwim);
        this.getPathingOptions().setCanSwim(canSwim);
    }

    @Override
    public BlockPos getDesiredPos() {
        return this.desiredPos;
    }

    @Override
    public void setStuckHandler(IStuckHandler stuckHandler) {
        this.stuckHandler = stuckHandler;
    }

    @Override
    public void setSwimSpeedFactor(double factor) {
        this.swimSpeedFactor = factor;
    }
}

