/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.keybindings;

import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.client.gui.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.client.keybindings.ModKeyBindings;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateSpellbook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class KeyHandler {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();

    public static void checkKeysPressed(int key) {
        ItemStack stack = StackUtil.getHeldSpellbook((PlayerEntity)KeyHandler.MINECRAFT.field_71439_g);
        if (key == ModKeyBindings.NEXT_SLOT.getKey().func_197937_c() && stack.func_77973_b() instanceof SpellBook) {
            if (!stack.func_77942_o()) {
                return;
            }
            CompoundNBT tag = stack.func_77978_p();
            int newMode = SpellBook.getMode(tag) + 1;
            if (newMode > 10) {
                newMode = 0;
            }
            KeyHandler.sendUpdatePacket(tag, newMode);
            return;
        }
        if (key == ModKeyBindings.PREVIOUS__SLOT.getKey().func_197937_c() && stack.func_77973_b() instanceof SpellBook) {
            if (!stack.func_77942_o()) {
                return;
            }
            CompoundNBT tag = stack.func_77978_p();
            int newMode = SpellBook.getMode(tag) - 1;
            if (newMode < 0) {
                newMode = 10;
            }
            KeyHandler.sendUpdatePacket(tag, newMode);
            return;
        }
        if (key == ModKeyBindings.OPEN_SPELL_SELECTION.getKey().func_197937_c()) {
            if (KeyHandler.MINECRAFT.field_71462_r instanceof GuiRadialMenu) {
                KeyHandler.MINECRAFT.field_71439_g.func_71053_j();
                return;
            }
            if (stack.func_77973_b() instanceof SpellBook && stack.func_77942_o() && KeyHandler.MINECRAFT.field_71462_r == null) {
                MINECRAFT.func_147108_a((Screen)new GuiRadialMenu(stack.func_77978_p()));
            }
        }
        if (key == ModKeyBindings.OPEN_BOOK.getKey().func_197937_c()) {
            if (KeyHandler.MINECRAFT.field_71462_r instanceof GuiSpellBook && !((GuiSpellBook)KeyHandler.MINECRAFT.field_71462_r).spell_name.func_230999_j_()) {
                KeyHandler.MINECRAFT.field_71439_g.func_71053_j();
                return;
            }
            if (stack.func_77973_b() instanceof SpellBook && stack.func_77942_o() && KeyHandler.MINECRAFT.field_71462_r == null) {
                GuiSpellBook.open(stack.func_77978_p(), ((SpellBook)stack.func_77973_b()).getTier().ordinal(), SpellBook.getUnlockedSpellString(stack.func_77978_p()));
            }
        }
    }

    @SubscribeEvent
    public static void mouseEvent(InputEvent.MouseInputEvent event) {
        if (KeyHandler.MINECRAFT.field_71439_g == null || KeyHandler.MINECRAFT.field_71462_r != null || event.getAction() != 1) {
            return;
        }
        KeyHandler.checkKeysPressed(event.getButton());
    }

    @SubscribeEvent
    public static void keyEvent(InputEvent.KeyInputEvent event) {
        if (KeyHandler.MINECRAFT.field_71439_g == null || KeyHandler.MINECRAFT.field_71462_r != null || event.getAction() != 1) {
            return;
        }
        KeyHandler.checkKeysPressed(event.getKey());
    }

    public static void sendUpdatePacket(CompoundNBT tag, int newMode) {
        String recipe = SpellBook.getRecipeString(tag, newMode);
        String name = SpellBook.getSpellName(tag, newMode);
        Networking.INSTANCE.sendToServer((Object)new PacketUpdateSpellbook(recipe, newMode, name));
    }
}

