/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.buttons;

import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class CraftingButton
extends GuiImageButton {
    int slotNum;
    public String spellTag;
    public String resourceIcon;
    public List<SpellValidationError> validationErrors;

    public CraftingButton(GuiSpellBook parent, int x, int y, int slotNum, Button.IPressable onPress) {
        super(x, y, 0, 0, 22, 20, 22, 20, "textures/gui/spell_glyph_slot.png", onPress);
        this.slotNum = slotNum;
        this.spellTag = "";
        this.resourceIcon = "";
        this.validationErrors = new LinkedList<SpellValidationError>();
        this.parent = parent;
    }

    public void clear() {
        this.spellTag = "";
        this.resourceIcon = "";
        this.validationErrors.clear();
    }

    @Override
    public void func_230430_a_(MatrixStack ms, int parX, int parY, float partialTicks) {
        if (this.field_230694_p_) {
            if (this.validationErrors.isEmpty()) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GL11.glColor4f((float)1.0f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
            if (!this.resourceIcon.equals("")) {
                GuiSpellBook.drawFromTexture(new ResourceLocation("ars_nouveau", "textures/items/" + this.resourceIcon), this.field_230690_l_ + 3, this.field_230691_m_ + 2, this.u, this.v, 16, 16, 16, 16, ms);
            }
            if (this.parent.isMouseInRelativeRange(parX, parY, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_) && this.parent.api.getSpell_map().containsKey(this.spellTag)) {
                LinkedList<Object> tooltip = new LinkedList<Object>();
                tooltip.add(new TranslationTextComponent(this.parent.api.getSpell_map().get(this.spellTag).getLocalizationKey()));
                for (SpellValidationError ve : this.validationErrors) {
                    tooltip.add(ve.makeTextComponentExisting().func_240699_a_(TextFormatting.RED));
                }
                this.parent.tooltip = tooltip;
            }
        }
        super.func_230430_a_(ms, parX, parY, partialTicks);
    }
}

