/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class MathUtil {
    public static long NIGHT_TIME = 13000L;
    public static long DAY_TIME = 1000L;

    public static EntityRayTraceResult getLookedAtEntity(LivingEntity entity, int range) {
        Vector3d vec3d = entity.func_174824_e(1.0f);
        Vector3d vec3d1 = entity.func_70676_i(1.0f);
        Vector3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)range, vec3d1.field_72448_b * (double)range, vec3d1.field_72449_c * (double)range);
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_216361_a(vec3d1.func_186678_a((double)range)).func_72314_b(1.0, 1.0, 1.0);
        return MathUtil.traceEntities((Entity)entity, vec3d, vec3d2, axisalignedbb, e -> !e.func_175149_v() && e.func_70067_L(), range);
    }

    public static EntityRayTraceResult traceEntities(Entity shooter, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, double distance) {
        World world = shooter.field_70170_p;
        double d0 = distance;
        Entity entity = null;
        Vector3d vec3d = null;
        for (Entity entity1 : world.func_175674_a(shooter, boundingBox, filter)) {
            Vector3d vec3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            Optional optional = axisalignedbb.func_216365_b(startVec, endVec);
            if (axisalignedbb.func_72318_a(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vec3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.func_72436_e(vec3d1 = (Vector3d)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == shooter.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vec3d = vec3d1;
                continue;
            }
            entity = entity1;
            vec3d = vec3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity, vec3d);
    }

    public static long getNextDaysTime(World world, long timeOfDay) {
        long lengthOfDay = 24000L;
        long dayTime = world.func_72820_D();
        long newTime = dayTime + lengthOfDay;
        newTime -= newTime % lengthOfDay;
        return newTime + timeOfDay;
    }
}

