/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.recipe;

import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RecipeWrapper {
    public Set<SingleRecipe> recipes = new HashSet<SingleRecipe>();

    public boolean addRecipe(SingleRecipe recipe) {
        return this.recipes.add(recipe);
    }

    public boolean addRecipe(List<Ingredient> recipe, ItemStack outputStack, IRecipe iRecipe) {
        return this.recipes.add(new SingleRecipe(recipe, outputStack, iRecipe));
    }

    public SingleRecipe canCraftFromInventory(Map<Item, Integer> inventory) {
        for (SingleRecipe recipe : this.recipes) {
            List<ItemStack> itemsNeeded = recipe.canCraftFromInventory(inventory);
            if (itemsNeeded == null) continue;
            return recipe;
        }
        return null;
    }

    public SingleRecipe canCraftPotionFromInventory(Map<Item, Integer> inventory, World world, BlockPos pos) {
        for (SingleRecipe recipe : this.recipes) {
            List<ItemStack> itemsNeeded = recipe.canCraftPotionFromInventory(inventory, world, pos);
            if (itemsNeeded == null) continue;
            return recipe;
        }
        return null;
    }

    public static class SingleRecipe {
        public List<Ingredient> recipe;
        public ItemStack outputStack;
        public IRecipe iRecipe;

        public SingleRecipe(List<Ingredient> ingredients, ItemStack outputStack, IRecipe iRecipe) {
            this.recipe = ingredients;
            this.outputStack = outputStack;
            this.iRecipe = iRecipe;
        }

        public List<ItemStack> canCraftPotionFromInventory(Map<Item, Integer> inventory, World world, BlockPos pos) {
            HashMap<Item, Integer> map = new HashMap<Item, Integer>(inventory);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (Ingredient i : this.recipe) {
                boolean foundStack = false;
                for (ItemStack stack : i.func_193365_a()) {
                    if (stack.func_77973_b() == Items.field_151068_bn) {
                        Potion potion = PotionUtils.func_185191_c((ItemStack)stack);
                        if (potion == Potions.field_185230_b || WixieCauldronTile.findNeededPotion(PotionUtils.func_185191_c((ItemStack)stack), 300, world, pos) != null) {
                            foundStack = true;
                            continue;
                        }
                        return null;
                    }
                    if (!inventory.containsKey(stack.func_77973_b()) || (Integer)map.get(stack.func_77973_b()) <= 0) continue;
                    map.put(stack.func_77973_b(), (Integer)map.get(stack.func_77973_b()) - 1);
                    foundStack = true;
                    items.add(stack.func_77946_l());
                    break;
                }
                if (foundStack) continue;
                return null;
            }
            return items;
        }

        public List<ItemStack> canCraftFromInventory(Map<Item, Integer> inventory) {
            HashMap<Item, Integer> map = new HashMap<Item, Integer>(inventory);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (Ingredient i : this.recipe) {
                boolean foundStack = false;
                for (ItemStack stack : i.func_193365_a()) {
                    if (!inventory.containsKey(stack.func_77973_b()) || (Integer)map.get(stack.func_77973_b()) <= 0) continue;
                    map.put(stack.func_77973_b(), (Integer)map.get(stack.func_77973_b()) - 1);
                    foundStack = true;
                    items.add(stack.func_77946_l());
                    break;
                }
                if (foundStack) continue;
                return null;
            }
            return items;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleRecipe recipe1 = (SingleRecipe)o;
            return Objects.equals(this.recipe, recipe1.recipe) && Objects.equals(this.outputStack, recipe1.outputStack);
        }

        public int hashCode() {
            return Objects.hash(this.recipe, this.outputStack);
        }
    }
}

