/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.enchanting_apparatus;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class EnchantmentRecipe
extends EnchantingApparatusRecipe {
    public Enchantment enchantment;
    public int enchantLevel;
    public static final String RECIPE_ID = "enchantment";

    public EnchantmentRecipe(List<Ingredient> pedestalItems, Enchantment enchantment, int level, int manaCost) {
        this.pedestalItems = pedestalItems;
        this.enchantment = enchantment;
        this.enchantLevel = level;
        this.manaCost = manaCost;
        this.id = new ResourceLocation("ars_nouveau", enchantment.getRegistryName().func_110623_a() + "_" + level);
    }

    public EnchantmentRecipe(ItemStack[] pedestalItems, Enchantment enchantment, int level, int manaCost) {
        ArrayList<Ingredient> ingres = new ArrayList<Ingredient>();
        for (ItemStack i : pedestalItems) {
            ingres.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{i.func_77973_b()}));
        }
        this.pedestalItems = ingres;
        this.enchantment = enchantment;
        this.enchantLevel = level;
        this.manaCost = manaCost;
        this.id = new ResourceLocation("ars_nouveau", enchantment.getRegistryName().func_110623_a() + "_" + level);
    }

    public EnchantmentRecipe(Ingredient[] pedestalItems, Enchantment enchantment, int level, int manaCost) {
        this.pedestalItems = Arrays.asList(pedestalItems);
        this.enchantment = enchantment;
        this.enchantLevel = level;
        this.manaCost = manaCost;
        this.id = new ResourceLocation("ars_nouveau", enchantment.getRegistryName().func_110623_a() + "_" + level);
    }

    @Override
    public IRecipeType<?> func_222127_g() {
        return (IRecipeType)Registry.field_218367_H.func_82594_a(new ResourceLocation("ars_nouveau", RECIPE_ID));
    }

    public boolean doesReagentMatch(ItemStack stack, PlayerEntity playerEntity) {
        if (stack.func_190926_b()) {
            return false;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int level = enchantments.getOrDefault(this.enchantment, 0);
        Set enchantList = EnchantmentHelper.func_82781_a((ItemStack)stack).keySet();
        enchantList.remove(this.enchantment);
        if (stack.func_77973_b() != Items.field_151122_aG && stack.func_77973_b() != Items.field_151134_bR && !this.enchantment.func_92089_a(stack)) {
            PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.enchanting.incompatible"));
            return false;
        }
        if (!EnchantmentHelper.func_201840_a(enchantList, (Enchantment)this.enchantment)) {
            PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.enchanting.incompatible"));
            return false;
        }
        if (this.enchantLevel - level != 1) {
            PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.enchanting.bad_level"));
            return false;
        }
        return true;
    }

    @Override
    public boolean isMatch(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile, @Nullable PlayerEntity player) {
        pedestalItems = pedestalItems.stream().filter(itemStack -> !itemStack.func_190926_b()).collect(Collectors.toList());
        return this.pedestalItems.size() == pedestalItems.size() && EnchantmentRecipe.doItemsMatch(pedestalItems, this.pedestalItems) && this.doesReagentMatch(reagent, player);
    }

    @Override
    public boolean doesReagentMatch(ItemStack stack) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int level = enchantments.getOrDefault(this.enchantment, 0);
        return this.enchantment.func_92089_a(stack) && this.enchantLevel - level == 1 && EnchantmentHelper.func_201840_a(EnchantmentHelper.func_82781_a((ItemStack)stack).keySet(), (Enchantment)this.enchantment);
    }

    @Override
    public ItemStack assemble(EnchantingApparatusTile inv) {
        ItemStack stack = inv.catalystItem.func_77973_b() == Items.field_151122_aG ? new ItemStack((IItemProvider)Items.field_151134_bR) : inv.catalystItem.func_77946_l();
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        enchantments.put(this.enchantment, this.enchantLevel);
        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
        return stack;
    }

    @Override
    public ItemStack getResult(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile tile) {
        return this.assemble(tile);
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return RecipeRegistry.ENCHANTMENT_SERIALIZER;
    }

    @Override
    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_nouveau:enchantment");
        jsonobject.addProperty(RECIPE_ID, this.enchantment.getRegistryName().toString());
        jsonobject.addProperty("level", (Number)this.enchantLevel);
        jsonobject.addProperty("mana", (Number)this.manaCost());
        int counter = 1;
        for (Ingredient i : this.pedestalItems) {
            JsonArray item = new JsonArray();
            item.add(i.func_200304_c());
            jsonobject.add("item_" + counter, (JsonElement)item);
            ++counter;
        }
        return jsonobject;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<EnchantmentRecipe> {
        public EnchantmentRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)EnchantmentRecipe.RECIPE_ID)));
            int level = JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1);
            int manaCost = JSONUtils.func_151208_a((JsonObject)json, (String)"mana", (int)0);
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 1; i < 9; ++i) {
                if (!json.has("item_" + i)) continue;
                stacks.add(Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)("item_" + i))));
            }
            return new EnchantmentRecipe(stacks, enchantment, level, manaCost);
        }

        @Nullable
        public EnchantmentRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int length = buffer.readInt();
            String enchantID = buffer.func_218666_n();
            int level = buffer.readInt();
            int manaCost = buffer.readInt();
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.func_199566_b((PacketBuffer)buffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            return new EnchantmentRecipe(stacks, (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantID)), level, manaCost);
        }

        public void toNetwork(PacketBuffer buf, EnchantmentRecipe recipe) {
            buf.writeInt(recipe.pedestalItems.size());
            buf.func_180714_a(recipe.enchantment.getRegistryName().toString());
            buf.writeInt(recipe.enchantLevel);
            buf.writeInt(recipe.manaCost());
            for (Ingredient i : recipe.pedestalItems) {
                i.func_199564_a(buf);
            }
        }
    }
}

