/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry.forge;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.architectury.core.RegistryEntry;
import me.shedaniel.architectury.platform.forge.EventBuses;
import me.shedaniel.architectury.registry.Registries;
import me.shedaniel.architectury.registry.Registry;
import me.shedaniel.architectury.registry.RegistrySupplier;
import me.shedaniel.architectury.registry.registries.RegistryBuilder;
import me.shedaniel.architectury.registry.registries.RegistryOption;
import me.shedaniel.architectury.registry.registries.StandardRegistryOption;
import net.minecraft.util.LazyValue;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;

public class RegistriesImpl {
    public static Registries.RegistryProvider _get(String modId) {
        return new RegistryProviderImpl(modId);
    }

    public static <T> ResourceLocation getId(T t, RegistryKey<net.minecraft.util.registry.Registry<T>> registryKey) {
        if (t instanceof IForgeRegistryEntry) {
            return ((IForgeRegistryEntry)t).getRegistryName();
        }
        return null;
    }

    public static <T> ResourceLocation getId(T t, net.minecraft.util.registry.Registry<T> registry) {
        if (t instanceof IForgeRegistryEntry) {
            return ((IForgeRegistryEntry)t).getRegistryName();
        }
        return null;
    }

    public static class RegistryProviderImpl
    implements Registries.RegistryProvider {
        private final String modId;
        private final LazyValue<IEventBus> eventBus;
        private final Map<Type, Data> registry = new HashMap<Type, Data>();
        private final Multimap<RegistryKey<net.minecraft.util.registry.Registry<?>>, Consumer<Registry<?>>> listeners = HashMultimap.create();

        public RegistryProviderImpl(String modId) {
            this.modId = modId;
            this.eventBus = new LazyValue(() -> {
                IEventBus eventBus = EventBuses.getModEventBus(modId).orElseThrow(() -> new IllegalStateException("Can't get event bus for mod '" + modId + "' because it was not registered!"));
                eventBus.register((Object)new EventListener());
                return eventBus;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEventBus() {
            LazyValue<IEventBus> lazyValue = this.eventBus;
            synchronized (lazyValue) {
                this.eventBus.func_179281_c();
            }
        }

        @Override
        public <T> Registry<T> get(RegistryKey<net.minecraft.util.registry.Registry<T>> registryKey) {
            this.updateEventBus();
            return this.get((IForgeRegistry)RegistryManager.ACTIVE.getRegistry(registryKey.func_240901_a_()));
        }

        public <T> Registry<T> get(IForgeRegistry registry) {
            this.updateEventBus();
            return new ForgeBackedRegistryImpl(this.registry, registry);
        }

        @Override
        public <T> Registry<T> get(net.minecraft.util.registry.Registry<T> registry) {
            this.updateEventBus();
            return new VanillaBackedRegistryImpl<T>(registry);
        }

        @Override
        public <T> void forRegistry(RegistryKey<net.minecraft.util.registry.Registry<T>> key, Consumer<Registry<T>> consumer) {
            this.listeners.put(key, consumer);
        }

        @Override
        public <T extends RegistryEntry<T>> RegistryBuilder<T> builder(Class<T> type, ResourceLocation registryId) {
            return new RegistryBuilderWrapper(this, new net.minecraftforge.registries.RegistryBuilder().setName(registryId).setType(type));
        }

        public class EventListener {
            @SubscribeEvent
            public void handleEvent(RegistryEvent.Register event) {
                IForgeRegistry registry = event.getRegistry();
                Registry archRegistry = RegistryProviderImpl.this.get(registry);
                for (Map.Entry typeDataEntry : RegistryProviderImpl.this.registry.entrySet()) {
                    if (typeDataEntry.getKey() != registry.getRegistrySuperType()) continue;
                    Data data = (Data)typeDataEntry.getValue();
                    data.collected = true;
                    for (Map.Entry entry : data.objects.entrySet()) {
                        registry.register((IForgeRegistryEntry)((Supplier)entry.getValue()).get());
                        ((RegistryObject)entry.getKey()).updateReference(registry);
                    }
                    data.objects.clear();
                }
                for (Map.Entry entry : RegistryProviderImpl.this.listeners.entries()) {
                    if (!((RegistryKey)entry.getKey()).func_240901_a_().equals((Object)registry.getRegistryName())) continue;
                    ((Consumer)entry.getValue()).accept(archRegistry);
                }
            }
        }
    }

    public static class ForgeBackedRegistryImpl<T extends IForgeRegistryEntry<T>>
    implements Registry<T> {
        private IForgeRegistry<T> delegate;
        private Map<Type, Data> registry;

        public ForgeBackedRegistryImpl(Map<Type, Data> registry, IForgeRegistry<T> delegate) {
            this.registry = registry;
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public RegistrySupplier<T> delegateSupplied(final ResourceLocation id) {
            final LazyValue value = new LazyValue(() -> this.get(id));
            return new RegistrySupplier<T>(){

                @Override
                @NotNull
                public ResourceLocation getRegistryId() {
                    return delegate.getRegistryName();
                }

                @Override
                @NotNull
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.contains(id);
                }

                @Override
                public T get() {
                    return (IForgeRegistryEntry)value.func_179281_c();
                }

                public int hashCode() {
                    return Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        @NotNull
        public <E extends T> RegistrySupplier<E> registerSupplied(final ResourceLocation id, Supplier<E> supplier) {
            final RegistryObject registryObject = RegistryObject.of((ResourceLocation)id, this.delegate);
            this.registry.computeIfAbsent(this.delegate.getRegistrySuperType(), type -> new Data()).register(this.delegate, registryObject, () -> (IForgeRegistryEntry)((IForgeRegistryEntry)supplier.get()).setRegistryName(id));
            return new RegistrySupplier<E>(){

                @Override
                @NotNull
                public ResourceLocation getRegistryId() {
                    return delegate.getRegistryName();
                }

                @Override
                @NotNull
                public ResourceLocation getId() {
                    return registryObject.getId();
                }

                @Override
                public boolean isPresent() {
                    return registryObject.isPresent();
                }

                @Override
                public E get() {
                    return registryObject.get();
                }

                public int hashCode() {
                    return Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        @Nullable
        public ResourceLocation getId(T obj) {
            return this.delegate.getKey(obj);
        }

        @Override
        public int getRawId(T obj) {
            return ((ForgeRegistry)this.delegate).getID(obj);
        }

        @Override
        public Optional<RegistryKey<T>> getKey(T t) {
            return Optional.ofNullable(this.getId(t)).map(id -> RegistryKey.func_240903_a_(this.key(), (ResourceLocation)id));
        }

        @Override
        @Nullable
        public T get(ResourceLocation id) {
            return (T)this.delegate.getValue(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)((ForgeRegistry)this.delegate).getValue(rawId);
        }

        @Override
        public boolean contains(ResourceLocation resourceLocation) {
            return this.delegate.containsKey(resourceLocation);
        }

        @Override
        public boolean containsValue(T t) {
            return this.delegate.containsValue(t);
        }

        @Override
        public Set<ResourceLocation> getIds() {
            return this.delegate.getKeys();
        }

        @Override
        public Set<Map.Entry<RegistryKey<T>, T>> entrySet() {
            return this.delegate.getEntries();
        }

        @Override
        public RegistryKey<? extends net.minecraft.util.registry.Registry<T>> key() {
            return RegistryKey.func_240904_a_((ResourceLocation)this.delegate.getRegistryName());
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }
    }

    public static class VanillaBackedRegistryImpl<T>
    implements Registry<T> {
        private net.minecraft.util.registry.Registry<T> delegate;

        public VanillaBackedRegistryImpl(net.minecraft.util.registry.Registry<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public RegistrySupplier<T> delegateSupplied(final ResourceLocation id) {
            final LazyValue value = new LazyValue(() -> this.get(id));
            return new RegistrySupplier<T>(){

                @Override
                @NotNull
                public ResourceLocation getRegistryId() {
                    return delegate.func_243578_f().func_240901_a_();
                }

                @Override
                @NotNull
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.contains(id);
                }

                @Override
                public T get() {
                    return value.func_179281_c();
                }

                public int hashCode() {
                    return Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        @NotNull
        public <E extends T> RegistrySupplier<E> registerSupplied(ResourceLocation id, Supplier<E> supplier) {
            net.minecraft.util.registry.Registry.func_218322_a(this.delegate, (ResourceLocation)id, supplier.get());
            return this.delegateSupplied(id);
        }

        @Override
        @Nullable
        public ResourceLocation getId(T obj) {
            return this.delegate.func_177774_c(obj);
        }

        @Override
        public int getRawId(T obj) {
            return this.delegate.func_148757_b(obj);
        }

        @Override
        public Optional<RegistryKey<T>> getKey(T t) {
            return this.delegate.func_230519_c_(t);
        }

        @Override
        @Nullable
        public T get(ResourceLocation id) {
            return (T)this.delegate.func_82594_a(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)this.delegate.func_148745_a(rawId);
        }

        @Override
        public boolean contains(ResourceLocation resourceLocation) {
            return this.delegate.func_148742_b().contains(resourceLocation);
        }

        @Override
        public boolean containsValue(T t) {
            return this.delegate.func_230519_c_(t).isPresent();
        }

        @Override
        public Set<ResourceLocation> getIds() {
            return this.delegate.func_148742_b();
        }

        @Override
        public Set<Map.Entry<RegistryKey<T>, T>> entrySet() {
            return this.delegate.func_239659_c_();
        }

        @Override
        public RegistryKey<? extends net.minecraft.util.registry.Registry<T>> key() {
            return this.delegate.func_243578_f();
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }
    }

    public static class RegistryBuilderWrapper<T extends RegistryEntry<T>>
    implements RegistryBuilder<T> {
        @NotNull
        private final RegistryProviderImpl provider;
        @NotNull
        private final net.minecraftforge.registries.RegistryBuilder<?> builder;
        private boolean saveToDisk = false;
        private boolean syncToClients = false;

        public RegistryBuilderWrapper(@NotNull RegistryProviderImpl provider, @NotNull net.minecraftforge.registries.RegistryBuilder<?> builder) {
            this.provider = provider;
            this.builder = builder;
        }

        @Override
        @NotNull
        public Registry<T> build() {
            if (!this.syncToClients) {
                this.builder.disableSync();
            }
            if (!this.saveToDisk) {
                this.builder.disableSaving();
            }
            return this.provider.get(this.builder.create());
        }

        @Override
        @NotNull
        public RegistryBuilder<T> option(@NotNull RegistryOption option) {
            if (option == StandardRegistryOption.SAVE_TO_DISC) {
                this.saveToDisk = true;
            } else if (option == StandardRegistryOption.SYNC_TO_CLIENTS) {
                this.syncToClients = true;
            }
            return this;
        }
    }

    public static class Data {
        private boolean collected = false;
        private final Map<RegistryObject<?>, Supplier<? extends IForgeRegistryEntry<?>>> objects = new LinkedHashMap();

        public void register(IForgeRegistry registry, RegistryObject object, Supplier<? extends IForgeRegistryEntry<?>> reference) {
            if (!this.collected) {
                this.objects.put(object, reference);
            } else {
                registry.register(reference.get());
                object.updateReference(registry);
            }
        }
    }
}

