/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry.forge;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.shedaniel.architectury.mixin.forge.ParticleEngineAccessor;
import me.shedaniel.architectury.registry.ParticleProviderRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="architectury", value={Dist.CLIENT})
public class ParticleProviderRegistryImpl {
    private static ArrayList<Runnable> deferred = new ArrayList();

    private static <T extends IParticleData> void _register(ParticleType<T> type, IParticleFactory<T> provider) {
        Minecraft.func_71410_x().field_71452_i.func_199283_a(type, provider);
    }

    private static <T extends IParticleData> void _register(ParticleType<T> type, ParticleProviderRegistry.DeferredParticleProvider<T> provider) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a(type, sprites -> provider.create(new ExtendedSpriteSetImpl(Minecraft.func_71410_x().field_71452_i, sprites)));
    }

    public static <T extends IParticleData> void register(ParticleType<T> type, IParticleFactory<T> provider) {
        if (deferred == null) {
            ParticleProviderRegistryImpl._register(type, provider);
        } else {
            deferred.add(() -> ParticleProviderRegistryImpl._register(type, provider));
        }
    }

    public static <T extends IParticleData> void register(ParticleType<T> type, ParticleProviderRegistry.DeferredParticleProvider<T> provider) {
        if (deferred == null) {
            ParticleProviderRegistryImpl._register(type, provider);
        } else {
            deferred.add(() -> ParticleProviderRegistryImpl._register(type, provider));
        }
    }

    @SubscribeEvent
    public static void onParticleFactoryRegister(ParticleFactoryRegisterEvent unused) {
        if (deferred != null) {
            for (Runnable runnable : deferred) {
                runnable.run();
            }
            deferred = null;
        }
    }

    private static final class ExtendedSpriteSetImpl
    implements ParticleProviderRegistry.ExtendedSpriteSet {
        private final ParticleManager engine;
        private final IAnimatedSprite delegate;

        private ExtendedSpriteSetImpl(ParticleManager engine, IAnimatedSprite delegate) {
            this.engine = engine;
            this.delegate = delegate;
        }

        @Override
        public AtlasTexture getAtlas() {
            return ((ParticleEngineAccessor)this.engine).getTextureAtlas();
        }

        @Override
        public List<TextureAtlasSprite> getSprites() {
            return ((ParticleEngineAccessor.MutableSpriteSetAccessor)this.delegate).getSprites();
        }

        public TextureAtlasSprite func_217591_a(int i, int j) {
            return this.delegate.func_217591_a(i, j);
        }

        public TextureAtlasSprite func_217590_a(Random random) {
            return this.delegate.func_217590_a(random);
        }
    }
}

