/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.definitions.IItemDefinition;
import appeng.api.features.InscriberProcessType;
import appeng.core.Api;
import appeng.recipes.handlers.InscriberRecipe;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public final class InscriberRecipes {
    public static final ResourceLocation NAMEPLATE_RECIPE_ID = new ResourceLocation("appliedenergistics2", "nameplate");

    private InscriberRecipes() {
    }

    public static Iterable<InscriberRecipe> getRecipes(World world) {
        Collection unfilteredRecipes = world.func_199532_z().func_215366_a(InscriberRecipe.TYPE).values();
        return Iterables.filter(unfilteredRecipes, InscriberRecipe.class);
    }

    @Nullable
    public static InscriberRecipe findRecipe(World world, ItemStack input, ItemStack plateA, ItemStack plateB, boolean supportNamePress) {
        if (supportNamePress) {
            IItemDefinition namePress = Api.instance().definitions().materials().namePress();
            boolean isNameA = namePress.isSameAs(plateA);
            boolean isNameB = namePress.isSameAs(plateB);
            if (isNameA && isNameB || isNameA && plateB.func_190926_b()) {
                return InscriberRecipes.makeNamePressRecipe(input, plateA, plateB);
            }
            if (plateA.func_190926_b() && isNameB) {
                return InscriberRecipes.makeNamePressRecipe(input, plateB, plateA);
            }
        }
        for (InscriberRecipe recipe : InscriberRecipes.getRecipes(world)) {
            boolean matchB;
            boolean matchA = recipe.getTopOptional().test(plateA) && recipe.getBottomOptional().test(plateB);
            boolean bl = matchB = recipe.getTopOptional().test(plateB) && recipe.getBottomOptional().test(plateA);
            if (!matchA && !matchB || !recipe.getMiddleInput().test(input)) continue;
            return recipe;
        }
        return null;
    }

    private static InscriberRecipe makeNamePressRecipe(ItemStack input, ItemStack plateA, ItemStack plateB) {
        CompoundNBT tag;
        String name = "";
        if (!plateA.func_190926_b()) {
            tag = plateA.func_196082_o();
            name = name + tag.func_74779_i("InscribeName");
        }
        if (!plateB.func_190926_b()) {
            tag = plateB.func_196082_o();
            name = name + " " + tag.func_74779_i("InscribeName");
        }
        Ingredient startingItem = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input.func_77946_l()});
        ItemStack renamedItem = input.func_77946_l();
        if (!name.isEmpty()) {
            renamedItem.func_200302_a((ITextComponent)new StringTextComponent(name));
        } else {
            renamedItem.func_200302_a(null);
        }
        InscriberProcessType type = InscriberProcessType.INSCRIBE;
        return new InscriberRecipe(NAMEPLATE_RECIPE_ID, "", startingItem, renamedItem, plateA.func_190926_b() ? Ingredient.field_193370_a : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{plateA}), plateB.func_190926_b() ? Ingredient.field_193370_a : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{plateB}), type);
    }

    public static boolean isValidOptionalIngredientCombination(World world, ItemStack pressA, ItemStack pressB) {
        for (InscriberRecipe recipe : InscriberRecipes.getRecipes(world)) {
            if ((!recipe.getTopOptional().test(pressA) || !recipe.getBottomOptional().test(pressB)) && (!recipe.getTopOptional().test(pressB) || !recipe.getBottomOptional().test(pressA))) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidOptionalIngredient(World world, ItemStack is) {
        for (InscriberRecipe recipe : InscriberRecipes.getRecipes(world)) {
            if (!recipe.getTopOptional().test(is) && !recipe.getBottomOptional().test(is)) continue;
            return true;
        }
        return false;
    }
}

