/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.tiles.ICrankable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.Api;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkPowerTileEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.items.IItemHandler;

public class ChargerTileEntity
extends AENetworkPowerTileEntity
implements ICrankable,
IGridTickable {
    private static final int POWER_MAXIMUM_AMOUNT = 1600;
    private static final int POWER_THRESHOLD = 1599;
    private static final int POWER_PER_CRANK_TURN = 160;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1, 1, new ChargerInvFilter());

    public ChargerTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setValidSides(EnumSet.noneOf(Direction.class));
        this.getProxy().setFlags(new GridFlags[0]);
        this.setInternalMaxPower(1600.0);
        this.getProxy().setIdlePowerUsage(0.0);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        try {
            AEItemStack item = AEItemStack.fromPacket(data);
            ItemStack is = item.createItemStack();
            this.inv.setStackInSlot(0, is);
        }
        catch (Throwable t) {
            this.inv.setStackInSlot(0, ItemStack.field_190927_a);
        }
        return c;
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        AEItemStack is = AEItemStack.fromItemStack(this.inv.getStackInSlot(0));
        if (is != null) {
            is.writeToPacket(data);
        }
    }

    @Override
    public void setOrientation(Direction inForward, Direction inUp) {
        super.setOrientation(inForward, inUp);
        this.getProxy().setValidSides(EnumSet.of(this.getUp(), this.getUp().func_176734_d()));
        this.setPowerSides(EnumSet.of(this.getUp(), this.getUp().func_176734_d()));
    }

    @Override
    public boolean canTurn() {
        return this.getInternalCurrentPower() < this.getInternalMaxPower();
    }

    @Override
    public void applyTurn() {
        IMaterials materials;
        this.injectExternalPower(PowerUnits.AE, 160.0, Actionable.MODULATE);
        ItemStack myItem = this.inv.getStackInSlot(0);
        if (this.getInternalCurrentPower() > 1599.0 && (materials = Api.instance().definitions().materials()).certusQuartzCrystal().isSameAs(myItem)) {
            this.extractAEPower(this.getInternalMaxPower(), Actionable.MODULATE, PowerMultiplier.CONFIG);
            materials.certusQuartzCrystalCharged().maybeStack(myItem.func_190916_E()).ifPresent(charged -> this.inv.setStackInSlot(0, (ItemStack)charged));
        }
    }

    @Override
    public boolean canCrankAttach(Direction directionToCrank) {
        return this.getUp() == directionToCrank || this.getUp().func_176734_d() == directionToCrank;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        try {
            this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.markForUpdate();
    }

    public void activate(PlayerEntity player) {
        if (!Platform.hasPermissions(new DimensionalCoord(this), player)) {
            return;
        }
        ItemStack myItem = this.inv.getStackInSlot(0);
        if (myItem.func_190926_b()) {
            ItemStack held = player.field_71071_by.func_70448_g();
            if (Api.instance().definitions().materials().certusQuartzCrystal().isSameAs(held) || Platform.isChargeable(held)) {
                held = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                this.inv.setStackInSlot(0, held);
            }
        } else {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(myItem);
            this.inv.setStackInSlot(0, ItemStack.field_190927_a);
            Platform.spawnDrops(this.field_145850_b, this.field_174879_c.func_177972_a(this.getForward()), drops);
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Charger.getMin(), TickRates.Charger.getMin(), false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        return this.doWork() ? TickRateModulation.FASTER : TickRateModulation.SLEEP;
    }

    private boolean doWork() {
        ItemStack myItem = this.inv.getStackInSlot(0);
        boolean changed = false;
        if (!myItem.func_190926_b()) {
            IMaterials materials = Api.instance().definitions().materials();
            if (Platform.isChargeable(myItem)) {
                IAEItemPowerStorage ps = (IAEItemPowerStorage)myItem.func_77973_b();
                if (ps.getAEMaxPower(myItem) > ps.getAECurrentPower(myItem)) {
                    double chargeRate = Api.instance().registries().charger().getChargeRate(myItem.func_77973_b());
                    double extractedAmount = this.extractAEPower(chargeRate, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    double missingChargeRate = chargeRate - extractedAmount;
                    double missingAEPower = ps.getAEMaxPower(myItem) - ps.getAECurrentPower(myItem);
                    double toExtract = Math.min(missingChargeRate, missingAEPower);
                    try {
                        extractedAmount += this.getProxy().getEnergy().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                    if (extractedAmount > 0.0) {
                        double adjustment = ps.injectAEPower(myItem, extractedAmount, Actionable.MODULATE);
                        this.setInternalCurrentPower(this.getInternalCurrentPower() + adjustment);
                        changed = true;
                    }
                }
            } else if (this.getInternalCurrentPower() > 1599.0 && materials.certusQuartzCrystal().isSameAs(myItem) && Platform.getRandomFloat() > 0.8f) {
                this.extractAEPower(this.getInternalMaxPower(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                materials.certusQuartzCrystalCharged().maybeStack(myItem.func_190916_E()).ifPresent(charged -> this.inv.setStackInSlot(0, (ItemStack)charged));
                changed = true;
            }
        }
        if (this.getInternalCurrentPower() < 1599.0) {
            try {
                double toExtract = Math.min(800.0, this.getInternalMaxPower() - this.getInternalCurrentPower());
                double extracted = this.getProxy().getEnergy().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                this.injectExternalPower(PowerUnits.AE, extracted, Actionable.MODULATE);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            changed = true;
        }
        if (changed) {
            this.markForUpdate();
        }
        return true;
    }

    private class ChargerInvFilter
    implements IAEItemFilter {
        private ChargerInvFilter() {
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int i, ItemStack itemstack) {
            IItemDefinition cert = Api.instance().definitions().materials().certusQuartzCrystal();
            return Platform.isChargeable(itemstack) || cert.isSameAs(itemstack);
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slotIndex, int amount) {
            IAEItemPowerStorage ips;
            ItemStack extractedItem = inv.getStackInSlot(slotIndex);
            if (Platform.isChargeable(extractedItem) && (ips = (IAEItemPowerStorage)extractedItem.func_77973_b()).getAECurrentPower(extractedItem) >= ips.getAEMaxPower(extractedItem)) {
                return true;
            }
            return Api.instance().definitions().materials().certusQuartzCrystalCharged().isSameAs(extractedItem);
        }
    }
}

