/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.parts.AEBasePart;
import appeng.parts.automation.PlaneConnections;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class PlaneConnectionHelper {
    private final AEBasePart part;

    public PlaneConnectionHelper(AEBasePart part) {
        this.part = part;
    }

    public PlaneConnections getConnections() {
        Direction facingUp;
        Direction facingRight;
        TileEntity hostTileEntity = this.getHostTileEntity();
        AEPartLocation side = this.part.getSide();
        switch (side) {
            case UP: {
                facingRight = Direction.EAST;
                facingUp = Direction.NORTH;
                break;
            }
            case DOWN: {
                facingRight = Direction.WEST;
                facingUp = Direction.NORTH;
                break;
            }
            case NORTH: {
                facingRight = Direction.WEST;
                facingUp = Direction.UP;
                break;
            }
            case SOUTH: {
                facingRight = Direction.EAST;
                facingUp = Direction.UP;
                break;
            }
            case WEST: {
                facingRight = Direction.SOUTH;
                facingUp = Direction.UP;
                break;
            }
            case EAST: {
                facingRight = Direction.NORTH;
                facingUp = Direction.UP;
                break;
            }
            default: {
                return PlaneConnections.of(false, false, false, false);
            }
        }
        boolean left = false;
        boolean right = false;
        boolean down = false;
        boolean up = false;
        if (hostTileEntity != null) {
            BlockPos pos;
            World world = hostTileEntity.func_145831_w();
            if (this.isCompatiblePlaneAdjacent(world.func_175625_s((pos = hostTileEntity.func_174877_v()).func_177972_a(facingRight.func_176734_d())))) {
                left = true;
            }
            if (this.isCompatiblePlaneAdjacent(world.func_175625_s(pos.func_177972_a(facingRight)))) {
                right = true;
            }
            if (this.isCompatiblePlaneAdjacent(world.func_175625_s(pos.func_177972_a(facingUp.func_176734_d())))) {
                down = true;
            }
            if (this.isCompatiblePlaneAdjacent(world.func_175625_s(pos.func_177972_a(facingUp)))) {
                up = true;
            }
        }
        return PlaneConnections.of(up, right, down, left);
    }

    public void getBoxes(IPartCollisionHelper bch) {
        boolean minX = true;
        boolean minY = true;
        int maxX = 15;
        int maxY = 15;
        TileEntity hostTile = this.getHostTileEntity();
        if (hostTile != null) {
            World world = hostTile.func_145831_w();
            BlockPos pos = hostTile.func_174877_v();
            Direction e = bch.getWorldX();
            Direction u = bch.getWorldY();
            if (this.isCompatiblePlaneAdjacent(world.func_175625_s(pos.func_177972_a(e.func_176734_d())))) {
                minX = false;
            }
            if (this.isCompatiblePlaneAdjacent(world.func_175625_s(pos.func_177972_a(e)))) {
                maxX = 16;
            }
            if (this.isCompatiblePlaneAdjacent(world.func_175625_s(pos.func_177972_a(u.func_176734_d())))) {
                minY = false;
            }
            if (this.isCompatiblePlaneAdjacent(world.func_175625_s(pos.func_177972_a(u)))) {
                maxY = 16;
            }
        }
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox((double)minX, (double)minY, 15.0, maxX, maxY, 16.0);
    }

    public void updateConnections() {
        TileEntity hostTile = this.getHostTileEntity();
        if (hostTile != null) {
            hostTile.requestModelDataUpdate();
        }
    }

    private boolean isCompatiblePlaneAdjacent(@Nullable TileEntity adjacentTileEntity) {
        if (adjacentTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)adjacentTileEntity).getPart(this.part.getSide());
            return p != null && p.getClass() == this.part.getClass();
        }
        return false;
    }

    private TileEntity getHostTileEntity() {
        IPartHost host = this.part.getHost();
        if (host != null) {
            return host.getTile();
        }
        return null;
    }
}

