/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IBlocks;
import appeng.core.Api;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.tile.qnb.QuantumBridgeTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class QuantumCalculator
extends MBCalculator<QuantumBridgeTileEntity, QuantumCluster> {
    public QuantumCalculator(QuantumBridgeTileEntity t) {
        super(t);
    }

    @Override
    public boolean checkMultiblockScale(BlockPos min, BlockPos max) {
        if ((max.func_177958_n() - min.func_177958_n() + 1) * (max.func_177956_o() - min.func_177956_o() + 1) * (max.func_177952_p() - min.func_177952_p() + 1) == 9) {
            int ones = (max.func_177958_n() - min.func_177958_n() == 0 ? 1 : 0) + (max.func_177956_o() - min.func_177956_o() == 0 ? 1 : 0) + (max.func_177952_p() - min.func_177952_p() == 0 ? 1 : 0);
            int threes = (max.func_177958_n() - min.func_177958_n() == 2 ? 1 : 0) + (max.func_177956_o() - min.func_177956_o() == 2 ? 1 : 0) + (max.func_177952_p() - min.func_177952_p() == 2 ? 1 : 0);
            return ones == 1 && threes == 2;
        }
        return false;
    }

    @Override
    public QuantumCluster createCluster(World w, BlockPos min, BlockPos max) {
        return new QuantumCluster(min, max);
    }

    @Override
    public boolean verifyInternalStructure(World w, BlockPos min, BlockPos max) {
        int num = 0;
        for (BlockPos p : BlockPos.func_218278_a((BlockPos)min, (BlockPos)max)) {
            IAEMultiBlock te = (IAEMultiBlock)w.func_175625_s(p);
            if (te == null || !te.isValid()) {
                return false;
            }
            num = (byte)(num + 1);
            IBlocks blocks = Api.instance().definitions().blocks();
            if (!(num == 5 ? !this.isBlockAtLocation((IBlockReader)w, p, blocks.quantumLink()) : !this.isBlockAtLocation((IBlockReader)w, p, blocks.quantumRing()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateTiles(QuantumCluster c, World w, BlockPos min, BlockPos max) {
        byte num = 0;
        int ringNum = 0;
        for (BlockPos p : BlockPos.func_218278_a((BlockPos)min, (BlockPos)max)) {
            byte flags;
            QuantumBridgeTileEntity te = (QuantumBridgeTileEntity)w.func_175625_s(p);
            if ((num = (byte)((byte)(num + 1))) == 5) {
                flags = num;
                c.setCenter(te);
            } else {
                flags = num == 1 || num == 3 || num == 7 || num == 9 ? (byte)(((QuantumBridgeTileEntity)this.target).getCorner() | num) : num;
                c.getRing()[ringNum] = te;
                ringNum = (byte)(ringNum + 1);
            }
            te.updateStatus(c, flags, true);
        }
    }

    @Override
    public boolean isValidTile(TileEntity te) {
        return te instanceof QuantumBridgeTileEntity;
    }

    private boolean isBlockAtLocation(IBlockReader w, BlockPos pos, IBlockDefinition def) {
        return def.maybeBlock().map(block -> block == w.func_180495_p(pos).func_177230_c()).orElse(false);
    }
}

