/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.ITickManager;
import appeng.core.AELog;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.MEP2PTunnelPart;
import appeng.parts.p2p.P2PTunnelPart;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Random;

public class P2PCache
implements IGridCache {
    private static final TunnelCollection<P2PTunnelPart> NULL_COLLECTION = new TunnelCollection(null, null);
    private final IGrid myGrid;
    private final HashMap<Short, P2PTunnelPart> inputs = new HashMap();
    private final Multimap<Short, P2PTunnelPart> outputs = LinkedHashMultimap.create();
    private final Random frequencyGenerator;

    public P2PCache(IGrid g) {
        this.myGrid = g;
        this.frequencyGenerator = new Random(g.hashCode());
    }

    @MENetworkEventSubscribe
    public void bootComplete(MENetworkBootingStatusChange bootStatus) {
        ITickManager tm = (ITickManager)this.myGrid.getCache(ITickManager.class);
        for (P2PTunnelPart me : this.inputs.values()) {
            if (!(me instanceof MEP2PTunnelPart)) continue;
            tm.wakeDevice(me.getGridNode());
        }
    }

    @MENetworkEventSubscribe
    public void bootComplete(MENetworkPowerStatusChange power) {
        ITickManager tm = (ITickManager)this.myGrid.getCache(ITickManager.class);
        for (P2PTunnelPart me : this.inputs.values()) {
            if (!(me instanceof MEP2PTunnelPart)) continue;
            tm.wakeDevice(me.getGridNode());
        }
    }

    @Override
    public void onUpdateTick() {
    }

    @Override
    public void removeNode(IGridNode node, IGridHost machine) {
        if (machine instanceof P2PTunnelPart) {
            if (machine instanceof MEP2PTunnelPart && !node.hasFlag(GridFlags.REQUIRE_CHANNEL)) {
                return;
            }
            P2PTunnelPart t = (P2PTunnelPart)machine;
            if (t.isOutput()) {
                this.outputs.remove((Object)t.getFrequency(), (Object)t);
            } else {
                this.inputs.remove(t.getFrequency());
            }
            this.updateTunnel(t.getFrequency(), !t.isOutput(), false);
        }
    }

    @Override
    public void addNode(IGridNode node, IGridHost machine) {
        if (machine instanceof P2PTunnelPart) {
            if (machine instanceof MEP2PTunnelPart && !node.hasFlag(GridFlags.REQUIRE_CHANNEL)) {
                return;
            }
            P2PTunnelPart t = (P2PTunnelPart)machine;
            if (t.isOutput()) {
                this.outputs.put((Object)t.getFrequency(), (Object)t);
            } else {
                this.inputs.put(t.getFrequency(), t);
            }
            this.updateTunnel(t.getFrequency(), !t.isOutput(), false);
        }
    }

    @Override
    public void onSplit(IGridStorage storageB) {
    }

    @Override
    public void onJoin(IGridStorage storageB) {
    }

    @Override
    public void populateGridStorage(IGridStorage storage) {
    }

    private void updateTunnel(short freq, boolean updateOutputs, boolean configChange) {
        for (P2PTunnelPart p : this.outputs.get((Object)freq)) {
            if (configChange) {
                p.onTunnelConfigChange();
            }
            p.onTunnelNetworkChange();
        }
        P2PTunnelPart in = this.inputs.get(freq);
        if (in != null) {
            if (configChange) {
                in.onTunnelConfigChange();
            }
            in.onTunnelNetworkChange();
        }
    }

    public void updateFreq(P2PTunnelPart t, short newFrequency) {
        if (this.outputs.containsValue((Object)t)) {
            this.outputs.remove((Object)t.getFrequency(), (Object)t);
        }
        if (this.inputs.containsValue(t)) {
            this.inputs.remove(t.getFrequency());
        }
        t.setFrequency(newFrequency);
        if (t.isOutput()) {
            this.outputs.put((Object)t.getFrequency(), (Object)t);
        } else {
            this.inputs.put(t.getFrequency(), t);
        }
        this.updateTunnel(t.getFrequency(), t.isOutput(), true);
        this.updateTunnel(t.getFrequency(), !t.isOutput(), true);
    }

    public short newFrequency() {
        short newFrequency;
        int cycles = 0;
        do {
            newFrequency = (short)this.frequencyGenerator.nextInt(65536);
            ++cycles;
        } while (newFrequency == 0 || this.inputs.containsKey(newFrequency));
        if (cycles > 25) {
            AELog.debug("Generating a new P2P frequency '%1$d' took %2$d cycles", newFrequency, cycles);
        }
        return newFrequency;
    }

    public TunnelCollection<P2PTunnelPart> getOutputs(short freq, Class<? extends P2PTunnelPart> c) {
        P2PTunnelPart in = this.inputs.get(freq);
        if (in == null) {
            return NULL_COLLECTION;
        }
        TunnelCollection<P2PTunnelPart> out = this.inputs.get(freq).getCollection(this.outputs.get((Object)freq), c);
        if (out == null) {
            return NULL_COLLECTION;
        }
        return out;
    }

    public P2PTunnelPart getInput(short freq) {
        return this.inputs.get(freq);
    }
}

