/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.fluids.container.FluidConfigurableContainer;
import appeng.fluids.parts.FluidLevelEmitterPart;
import appeng.fluids.util.IAEFluidTank;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;

public class FluidLevelEmitterContainer
extends FluidConfigurableContainer {
    public static final ContainerType<FluidLevelEmitterContainer> TYPE = ContainerTypeBuilder.create(FluidLevelEmitterContainer::new, FluidLevelEmitterPart.class).requirePermission(SecurityPermissions.BUILD).withInitialData((host, buffer) -> buffer.func_179254_b(host.getReportingValue()), (host, container, buffer) -> {
        container.reportingValue = buffer.func_179260_f();
    }).build("fluid_level_emitter");
    private final FluidLevelEmitterPart lvlEmitter;
    private long reportingValue;

    public FluidLevelEmitterContainer(int id, PlayerInventory ip, FluidLevelEmitterPart te) {
        super(TYPE, id, ip, te);
        this.lvlEmitter = te;
    }

    public long getReportingValue() {
        return this.reportingValue;
    }

    public void setReportingValue(long reportingValue) {
        if (this.isClient()) {
            if (reportingValue != this.reportingValue) {
                this.reportingValue = reportingValue;
                NetworkHandler.instance().sendToServer(new ConfigValuePacket("FluidLevelEmitter.Value", String.valueOf(reportingValue)));
            }
        } else {
            this.lvlEmitter.setReportingValue(reportingValue);
        }
    }

    @Override
    protected void setupConfig() {
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 0;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            this.setRedStoneMode((RedstoneMode)this.getUpgradeable().getConfigManager().getSetting(Settings.REDSTONE_EMITTER));
        }
        this.standardDetectAndSendChanges();
    }

    @Override
    public IAEFluidTank getFluidConfigInventory() {
        return this.lvlEmitter.getConfig();
    }
}

