/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.networktool;

import appeng.api.implementations.guiobjects.INetworkTool;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.AEPartLocation;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.me.networktool.NetworkStatus;
import appeng.core.sync.packets.NetworkStatusPacket;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;

public class NetworkStatusContainer
extends AEBaseContainer {
    public static final ContainerType<NetworkStatusContainer> TYPE = ContainerTypeBuilder.create(NetworkStatusContainer::new, INetworkTool.class).build("networkstatus");
    private IGrid grid;
    private int delay = 40;

    public NetworkStatusContainer(int id, PlayerInventory ip, INetworkTool te) {
        super(TYPE, id, ip, null);
        IGridHost host = te.getGridHost();
        if (host != null) {
            this.findNode(host, AEPartLocation.INTERNAL);
            for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                this.findNode(host, d);
            }
        }
        if (this.grid == null && this.isServer()) {
            this.setValidContainer(false);
        }
    }

    private void findNode(IGridHost host, AEPartLocation d) {
        IGridNode node;
        if (this.grid == null && (node = host.getGridNode(d)) != null) {
            this.grid = node.getGrid();
        }
    }

    @Override
    public void func_75142_b() {
        ++this.delay;
        if (this.isServer() && this.delay > 15 && this.grid != null) {
            this.delay = 0;
            NetworkStatus status = NetworkStatus.fromGrid(this.grid);
            this.sendPacketToClient(new NetworkStatusPacket(status));
        }
        super.func_75142_b();
    }
}

