/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.items;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.container.me.items.ItemTerminalContainer;
import java.util.Objects;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;

public class MEPortableCellContainer
extends ItemTerminalContainer {
    public static final ContainerType<MEPortableCellContainer> TYPE = ContainerTypeBuilder.create(MEPortableCellContainer::new, IPortableCell.class).build("meportablecell");
    private final IPortableCell cell;
    private final int slot;
    private int ticks = 0;
    private double powerMultiplier = 0.5;

    protected MEPortableCellContainer(ContainerType<? extends MEPortableCellContainer> type, int id, PlayerInventory ip, IPortableCell monitorable) {
        super(type, id, ip, monitorable, false);
        this.slot = monitorable instanceof IInventorySlotAware ? ((IInventorySlotAware)((Object)monitorable)).getInventorySlot() : ip.field_70461_c;
        this.lockPlayerInventorySlot(this.slot);
        this.cell = Objects.requireNonNull(monitorable);
        this.createPlayerInventorySlots(ip);
    }

    @Override
    public void func_75142_b() {
        if (!this.ensureGuiItemIsInSlot(this.cell, this.slot)) {
            this.setValidContainer(false);
            return;
        }
        ++this.ticks;
        if (this.ticks > 10) {
            this.cell.extractAEPower(this.getPowerMultiplier() * (double)this.ticks, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.ticks = 0;
        }
        super.func_75142_b();
    }

    private double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    void setPowerMultiplier(double powerMultiplier) {
        this.powerMultiplier = powerMultiplier;
    }
}

