/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.crafting;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.me.crafting.CraftConfirmContainer;
import appeng.container.slot.InaccessibleSlot;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfirmAutoCraftPacket;
import appeng.me.helpers.PlayerSource;
import appeng.tile.inventory.AppEngInternalInventory;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class CraftAmountContainer
extends AEBaseContainer {
    public static final ContainerType<CraftAmountContainer> TYPE = ContainerTypeBuilder.create(CraftAmountContainer::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("craftamount");
    private final Slot craftingItem = new InaccessibleSlot((IItemHandler)new AppEngInternalInventory(null, 1), 0);
    private IAEItemStack itemToCreate;
    @GuiSync(value=1)
    private int initialAmount = -1;

    public CraftAmountContainer(int id, PlayerInventory ip, ITerminalHost te) {
        super(TYPE, id, ip, te);
        this.addSlot(this.craftingItem, SlotSemantic.MACHINE_OUTPUT);
    }

    public static void open(ServerPlayerEntity player, ContainerLocator locator, IAEItemStack itemToCraft, int initialAmount) {
        ContainerOpener.openContainer(TYPE, (PlayerEntity)player, locator);
        if (player.field_71070_bA instanceof CraftAmountContainer) {
            CraftAmountContainer cca = (CraftAmountContainer)player.field_71070_bA;
            cca.setItemToCraft(itemToCraft, initialAmount);
            cca.func_75142_b();
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    public IGrid getGrid() {
        IActionHost h = (IActionHost)this.getTarget();
        return h.getActionableNode().getGrid();
    }

    public World getWorld() {
        return this.getPlayerInventory().field_70458_d.field_70170_p;
    }

    public IActionSource getActionSrc() {
        return new PlayerSource(this.getPlayerInventory().field_70458_d, (IActionHost)this.getTarget());
    }

    private void setItemToCraft(@Nonnull IAEItemStack itemToCreate, int initialAmount) {
        this.itemToCreate = itemToCreate.copy();
        this.initialAmount = initialAmount;
        this.craftingItem.func_75215_d(itemToCreate.asItemStackRepresentation());
    }

    public void confirm(int amount, boolean autoStart) {
        if (!this.isServer()) {
            NetworkHandler.instance().sendToServer(new ConfirmAutoCraftPacket(amount, autoStart));
            return;
        }
        Object target = this.getTarget();
        if (target instanceof IActionHost) {
            IActionHost ah = (IActionHost)target;
            IGridNode gn = ah.getActionableNode();
            if (gn == null) {
                return;
            }
            IGrid g = gn.getGrid();
            if (g == null || this.itemToCreate == null) {
                return;
            }
            this.itemToCreate.setStackSize(amount);
            Future<ICraftingJob> futureJob = null;
            try {
                ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                futureJob = cg.beginCraftingJob(this.getWorld(), this.getGrid(), this.getActionSrc(), this.itemToCreate, null);
                ContainerLocator locator = this.getLocator();
                if (locator != null) {
                    PlayerEntity player = this.getPlayerInventory().field_70458_d;
                    ContainerOpener.openContainer(CraftConfirmContainer.TYPE, player, locator);
                    if (player.field_71070_bA instanceof CraftConfirmContainer) {
                        CraftConfirmContainer ccc = (CraftConfirmContainer)player.field_71070_bA;
                        ccc.setAutoStart(autoStart);
                        ccc.setItemToCreate(this.itemToCreate.copy());
                        ccc.setJob(futureJob);
                        this.func_75142_b();
                    }
                }
            }
            catch (Throwable e) {
                if (futureJob != null) {
                    futureJob.cancel(true);
                }
                AELog.info(e);
            }
        }
    }

    public int getInitialAmount() {
        return this.initialAmount;
    }
}

