/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.common;

import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;

public class GridInventoryEntry<T extends IAEStack<T>> {
    private final long serial;
    @Nullable
    private final T stack;
    private final long storedAmount;
    private final long requestableAmount;
    private final boolean craftable;

    public GridInventoryEntry(long serial, @Nullable T stack, long storedAmount, long requestableAmount, boolean craftable) {
        this.serial = serial;
        this.stack = stack;
        this.storedAmount = storedAmount;
        this.requestableAmount = requestableAmount;
        this.craftable = craftable;
    }

    public long getSerial() {
        return this.serial;
    }

    public T getStack() {
        return this.stack;
    }

    public long getStoredAmount() {
        return this.storedAmount;
    }

    public long getRequestableAmount() {
        return this.requestableAmount;
    }

    public boolean isCraftable() {
        return this.craftable;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179254_b(this.serial);
        buffer.writeBoolean(this.stack != null);
        if (this.stack != null) {
            this.stack.writeToPacket(buffer);
        }
        buffer.func_179254_b(this.storedAmount);
        buffer.func_179254_b(this.requestableAmount);
        buffer.writeBoolean(this.craftable);
    }

    public static <T extends IAEStack<T>> GridInventoryEntry<T> read(IStorageChannel<T> storageChannel, PacketBuffer buffer) {
        long serial = buffer.func_179260_f();
        T stack = null;
        if (buffer.readBoolean()) {
            stack = storageChannel.readFromPacket(buffer);
        }
        long storedAmount = buffer.func_179260_f();
        long requestableAmount = buffer.func_179260_f();
        boolean craftable = buffer.readBoolean();
        return new GridInventoryEntry<Object>(serial, stack, storedAmount, requestableAmount, craftable);
    }

    public boolean isMeaningful() {
        return this.storedAmount > 0L || this.requestableAmount > 0L || this.craftable;
    }
}

