/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.CondenserOutput;
import appeng.api.config.Settings;
import appeng.container.AEBaseContainer;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.tile.misc.CondenserTileEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.items.IItemHandler;

public class CondenserContainer
extends AEBaseContainer
implements IProgressProvider {
    public static final ContainerType<CondenserContainer> TYPE = ContainerTypeBuilder.create(CondenserContainer::new, CondenserTileEntity.class).build("condenser");
    private final CondenserTileEntity condenser;
    @GuiSync(value=0)
    public long requiredEnergy = 0L;
    @GuiSync(value=1)
    public long storedPower = 0L;
    @GuiSync(value=2)
    public CondenserOutput output = CondenserOutput.TRASH;

    public CondenserContainer(int id, PlayerInventory ip, CondenserTileEntity condenser) {
        super(TYPE, id, ip, condenser);
        this.condenser = condenser;
        IItemHandler inv = condenser.getInternalInventory();
        this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.TRASH, inv, 0), SlotSemantic.MACHINE_INPUT);
        this.addSlot(new OutputSlot(inv, 1, null), SlotSemantic.MACHINE_OUTPUT);
        this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.STORAGE_COMPONENT, inv, 2).setStackLimit(1), SlotSemantic.STORAGE_CELL);
        this.createPlayerInventorySlots(ip);
    }

    @Override
    public void func_75142_b() {
        if (this.isServer()) {
            double maxStorage = this.condenser.getStorage();
            double requiredEnergy = this.condenser.getRequiredPower();
            this.requiredEnergy = requiredEnergy == 0.0 ? (long)((int)maxStorage) : (long)((int)Math.min(requiredEnergy, maxStorage));
            this.storedPower = (int)this.condenser.getStoredPower();
            this.output = (CondenserOutput)this.condenser.getConfigManager().getSetting(Settings.CONDENSER_OUTPUT);
        }
        super.func_75142_b();
    }

    @Override
    public int getCurrentProgress() {
        return (int)this.storedPower;
    }

    @Override
    public int getMaxProgress() {
        return (int)this.requiredEnergy;
    }

    public CondenserOutput getOutput() {
        return this.output;
    }
}

