/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.style;

import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.BlitterDeserializer;
import appeng.client.gui.style.Color;
import appeng.client.gui.style.ColorDeserializer;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.Rectangle2dDeserializer;
import appeng.client.gui.style.SlotPosition;
import appeng.client.gui.style.TerminalStyle;
import appeng.client.gui.style.Text;
import appeng.client.gui.style.WidgetStyle;
import appeng.container.SlotSemantic;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;

public class ScreenStyle {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer()).registerTypeAdapter(Blitter.class, (Object)BlitterDeserializer.INSTANCE).registerTypeAdapter(Rectangle2d.class, (Object)Rectangle2dDeserializer.INSTANCE).registerTypeAdapter(Color.class, (Object)ColorDeserializer.INSTANCE).create();
    private final Map<SlotSemantic, SlotPosition> slots = new EnumMap<SlotSemantic, SlotPosition>(SlotSemantic.class);
    private final Map<String, Text> text = new HashMap<String, Text>();
    private final Map<PaletteColor, Color> palette = new EnumMap<PaletteColor, Color>(PaletteColor.class);
    private final Map<String, Blitter> images = new HashMap<String, Blitter>();
    @Nullable
    private Blitter background;
    @Nullable
    private TerminalStyle terminalStyle;
    private final Map<String, WidgetStyle> widgets = new HashMap<String, WidgetStyle>();

    public Color getColor(PaletteColor color) {
        return this.palette.get((Object)color);
    }

    public Map<SlotSemantic, SlotPosition> getSlots() {
        return this.slots;
    }

    public Map<String, Text> getText() {
        return this.text;
    }

    public Blitter getBackground() {
        return this.background != null ? this.background.copy() : null;
    }

    public WidgetStyle getWidget(String id) {
        WidgetStyle widget = this.widgets.get(id);
        if (widget == null) {
            throw new IllegalStateException("Screen is missing required widget: " + id);
        }
        return widget;
    }

    @Nonnull
    public Blitter getImage(String id) {
        Blitter blitter = this.images.get(id);
        if (blitter == null) {
            throw new IllegalStateException("Screen is missing required image: " + id);
        }
        return blitter;
    }

    @Nullable
    public TerminalStyle getTerminalStyle() {
        return this.terminalStyle;
    }

    public void validate() {
        for (PaletteColor value : PaletteColor.values()) {
            if (this.palette.containsKey((Object)value)) continue;
            throw new RuntimeException("Palette is missing color " + (Object)((Object)value));
        }
        if (this.terminalStyle != null) {
            this.terminalStyle.validate();
        }
    }
}

