/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.util.ISlimReadableNumberConverter;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.ReadableNumberConverter;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;

public class StackSizeRenderer {
    protected static final ISlimReadableNumberConverter SLIM_CONVERTER = ReadableNumberConverter.INSTANCE;
    protected static final IWideReadableNumberConverter WIDE_CONVERTER = ReadableNumberConverter.INSTANCE;

    public void renderStackSize(FontRenderer fontRenderer, long stackSize, boolean craftable, int xPos, int yPos) {
        if (stackSize == 0L && craftable) {
            String craftLabelText = AEConfig.instance().isUseLargeFonts() ? GuiText.LargeFontCraft.getLocal() : GuiText.SmallFontCraft.getLocal();
            this.renderSizeLabel(fontRenderer, xPos, yPos, craftLabelText);
        }
        if (stackSize > 0L) {
            this.renderSizeLabel(fontRenderer, xPos, yPos, this.getToBeRenderedStackSize(stackSize));
        }
    }

    public void renderSizeLabel(FontRenderer fontRenderer, float xPos, float yPos, String text) {
        float scaleFactor = AEConfig.instance().isUseLargeFonts() ? 0.85f : 0.5f;
        float inverseScaleFactor = 1.0f / scaleFactor;
        int offset = AEConfig.instance().isUseLargeFonts() ? 0 : -1;
        TransformationMatrix tm = new TransformationMatrix(new Vector3f(0.0f, 0.0f, 300.0f), null, new Vector3f(scaleFactor, scaleFactor, scaleFactor), null);
        RenderSystem.disableBlend();
        int X = (int)((xPos + (float)offset + 16.0f - (float)fontRenderer.func_78256_a(text) * scaleFactor) * inverseScaleFactor);
        int Y = (int)((yPos + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        fontRenderer.func_228079_a_(text, (float)X, (float)Y, 0xFFFFFF, true, tm.func_227988_c_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
        buffer.func_228461_a_();
        RenderSystem.enableBlend();
    }

    protected String getToBeRenderedStackSize(long originalSize) {
        if (AEConfig.instance().isUseLargeFonts()) {
            return SLIM_CONVERTER.toSlimReadableForm(originalSize);
        }
        return WIDE_CONVERTER.toWideReadableForm(originalSize);
    }
}

