/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.spawner;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import shadows.apotheosis.spawn.SpawnerModule;
import shadows.apotheosis.spawn.spawner.LyingLevel;

public class ApothSpawnerTile
extends MobSpawnerTileEntity {
    public boolean ignoresPlayers = false;
    public boolean ignoresConditions = false;
    public boolean redstoneControl = false;
    public boolean ignoresLight = false;
    public boolean hasNoAI = false;
    public boolean silent = false;

    public ApothSpawnerTile() {
        this.field_145882_a = new SpawnerLogicExt();
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74757_a("ignore_players", this.ignoresPlayers);
        tag.func_74757_a("ignore_conditions", this.ignoresConditions);
        tag.func_74757_a("redstone_control", this.redstoneControl);
        tag.func_74757_a("ignore_light", this.ignoresLight);
        tag.func_74757_a("no_ai", this.hasNoAI);
        tag.func_74757_a("silent", this.silent);
        return super.func_189515_b(tag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.ignoresPlayers = tag.func_74767_n("ignore_players");
        this.ignoresConditions = tag.func_74767_n("ignore_conditions");
        this.redstoneControl = tag.func_74767_n("redstone_control");
        this.ignoresLight = tag.func_74767_n("ignore_light");
        this.hasNoAI = tag.func_74767_n("no_ai");
        this.silent = tag.func_74767_n("silent");
        super.func_230337_a_(state, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(Blocks.field_150474_ac.func_176223_P(), pkt.func_148857_g());
    }

    public class SpawnerLogicExt
    extends AbstractSpawner {
        public void func_200876_a(EntityType<?> pType) {
            super.func_200876_a(pType);
            this.field_98285_e.clear();
            this.field_98285_e.add(this.field_98282_f);
            if (ApothSpawnerTile.this.field_145850_b != null) {
                this.reset();
            }
        }

        public void func_98267_a(int id) {
            ApothSpawnerTile.this.field_145850_b.func_175641_c(ApothSpawnerTile.this.field_174879_c, Blocks.field_150474_ac, id, 0);
        }

        public World func_98271_a() {
            return ApothSpawnerTile.this.field_145850_b;
        }

        public BlockPos func_177221_b() {
            return ApothSpawnerTile.this.field_174879_c;
        }

        @Nullable
        public Entity func_184994_d() {
            if (this.field_98291_j == null) {
                CompoundNBT tag = this.field_98282_f.func_185277_b();
                EntityType.func_220347_a((CompoundNBT)tag).ifPresent(e -> {
                    this.field_98291_j = e.func_200721_a(this.func_98271_a());
                    try {
                        this.field_98291_j.func_70020_e(tag);
                    }
                    catch (Exception ex) {
                        SpawnerModule.LOG.error("Exception occurred reading entity nbt for client cache - likely MC-189565");
                    }
                });
            }
            return this.field_98291_j;
        }

        public void func_184993_a(WeightedSpawnerEntity nextSpawnData) {
            super.func_184993_a(nextSpawnData);
            if (this.func_98271_a() != null) {
                BlockState state = this.func_98271_a().func_180495_p(this.func_177221_b());
                this.func_98271_a().func_184138_a(ApothSpawnerTile.this.field_174879_c, state, state, 4);
            }
        }

        private boolean isActivated() {
            BlockPos pos = this.func_177221_b();
            World level = this.func_98271_a();
            boolean flag = ApothSpawnerTile.this.ignoresPlayers || level.func_217358_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)this.field_98289_l);
            return flag && (!ApothSpawnerTile.this.redstoneControl || ApothSpawnerTile.this.field_145850_b.func_175640_z(pos));
        }

        private void reset() {
            World pLevel = this.func_98271_a();
            this.field_98286_b = this.field_98293_h <= this.field_98283_g ? this.field_98283_g : this.field_98283_g + pLevel.field_73012_v.nextInt(this.field_98293_h - this.field_98283_g);
            if (!this.field_98285_e.isEmpty()) {
                this.func_184993_a((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.func_98271_a().field_73012_v, (List)this.field_98285_e));
            }
            this.func_98267_a(1);
        }

        public void func_98278_g() {
            if (!this.isActivated()) {
                this.field_98284_d = this.field_98287_c;
            } else {
                World world = this.func_98271_a();
                BlockPos pPos = this.func_177221_b();
                if (world.field_72995_K) {
                    double nX = (float)pPos.func_177958_n() + world.field_73012_v.nextFloat();
                    double nY = (float)pPos.func_177956_o() + world.field_73012_v.nextFloat();
                    double nZ = (float)pPos.func_177952_p() + world.field_73012_v.nextFloat();
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, nX, nY, nZ, 0.0, 0.0, 0.0);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, nX, nY, nZ, 0.0, 0.0, 0.0);
                    if (this.field_98286_b > 0) {
                        --this.field_98286_b;
                    }
                    this.field_98284_d = this.field_98287_c;
                    this.field_98287_c = (this.field_98287_c + (double)(1000.0f / ((float)this.field_98286_b + 200.0f))) % 360.0;
                } else {
                    if (this.field_98286_b == -1) {
                        this.reset();
                    }
                    if (this.field_98286_b > 0) {
                        --this.field_98286_b;
                        return;
                    }
                    boolean flag = false;
                    for (int i = 0; i < this.field_98294_i; ++i) {
                        int nearby;
                        Entity entity;
                        double z;
                        CompoundNBT tag = this.field_98282_f.func_185277_b();
                        Optional optional = EntityType.func_220347_a((CompoundNBT)tag);
                        if (!optional.isPresent()) {
                            this.reset();
                            return;
                        }
                        tag.func_82580_o("NoAI");
                        ListNBT listnbt = tag.func_150295_c("Pos", 6);
                        int j = listnbt.size();
                        double x = j >= 1 ? listnbt.func_150309_d(0) : (double)pPos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5;
                        double y = j >= 2 ? listnbt.func_150309_d(1) : (double)(pPos.func_177956_o() + world.field_73012_v.nextInt(3) - 1);
                        double d = z = j >= 3 ? listnbt.func_150309_d(2) : (double)pPos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5;
                        if (!world.func_226664_a_(((EntityType)optional.get()).func_220328_a(x, y, z))) continue;
                        BlockPos blockpos = new BlockPos(x, y, z);
                        LyingLevel liar = new LyingLevel(world);
                        boolean useLiar = false;
                        if (!ApothSpawnerTile.this.ignoresConditions) {
                            if (ApothSpawnerTile.this.ignoresLight) {
                                for (int light = 0; light < 16; ++light) {
                                    liar.setFakeLightLevel(light);
                                    if (!this.checkSpawnRules(optional, liar, blockpos)) continue;
                                    useLiar = true;
                                    break;
                                }
                            } else if (!this.checkSpawnRules(optional, (IServerWorld)world, blockpos)) continue;
                        }
                        if ((entity = EntityType.func_220335_a((CompoundNBT)tag, (World)world, newEntity -> {
                            newEntity.func_70012_b(x, y, z, newEntity.field_70177_z, newEntity.field_70125_A);
                            return newEntity;
                        })) == null) {
                            this.reset();
                            return;
                        }
                        if (ApothSpawnerTile.this.hasNoAI && entity instanceof MobEntity) {
                            ((MobEntity)entity).func_94061_f(true);
                            entity.getPersistentData().func_74757_a("apotheosis:movable", true);
                        }
                        if (ApothSpawnerTile.this.silent) {
                            entity.func_174810_b(true);
                        }
                        if ((nearby = world.func_217357_a(entity.getClass(), new AxisAlignedBB((double)pPos.func_177958_n(), (double)pPos.func_177956_o(), (double)pPos.func_177952_p(), (double)(pPos.func_177958_n() + 1), (double)(pPos.func_177956_o() + 1), (double)(pPos.func_177952_p() + 1)).func_186662_g((double)this.field_98290_m)).size()) >= this.field_98292_k) {
                            this.reset();
                            return;
                        }
                        entity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (entity instanceof MobEntity) {
                            MobEntity mob = (MobEntity)entity;
                            Event.Result res = ForgeEventFactory.canEntitySpawn((MobEntity)mob, (IWorld)(useLiar ? liar : world), (double)((float)entity.func_226277_ct_()), (double)((float)entity.func_226278_cu_()), (double)((float)entity.func_226281_cx_()), (AbstractSpawner)this, (SpawnReason)SpawnReason.SPAWNER);
                            if (res == Event.Result.DENY || res == Event.Result.DEFAULT && !ApothSpawnerTile.this.ignoresConditions && (!mob.func_213380_a((IWorld)(useLiar ? liar : world), SpawnReason.SPAWNER) || !mob.func_205019_a((IWorldReader)world))) continue;
                            if (this.field_98282_f.func_185277_b().func_186856_d() == 1 && this.field_98282_f.func_185277_b().func_150297_b("id", 8) && !ForgeEventFactory.doSpecialSpawn((MobEntity)mob, (World)world, (float)((float)entity.func_226277_ct_()), (float)((float)entity.func_226278_cu_()), (float)((float)entity.func_226281_cx_()), (AbstractSpawner)this, (SpawnReason)SpawnReason.SPAWNER)) {
                                mob.func_213386_a((IServerWorld)world, world.func_175649_E(entity.func_233580_cy_()), SpawnReason.SPAWNER, null, null);
                            }
                        }
                        if (!((ServerWorld)world).func_242106_g(entity)) {
                            this.reset();
                            return;
                        }
                        world.func_217379_c(2004, pPos, 0);
                        if (entity instanceof MobEntity) {
                            ((MobEntity)entity).func_70656_aK();
                        }
                        flag = true;
                    }
                    if (flag) {
                        this.reset();
                    }
                }
            }
        }

        private boolean checkSpawnRules(Optional<EntityType<?>> optional, IServerWorld pServerLevel, BlockPos blockpos) {
            return EntitySpawnPlacementRegistry.func_223515_a(optional.get(), (IServerWorld)pServerLevel, (SpawnReason)SpawnReason.SPAWNER, (BlockPos)blockpos, (Random)pServerLevel.func_201674_k());
        }
    }
}

