/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.compat;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import shadows.apotheosis.spawn.modifiers.SpawnerStats;
import shadows.apotheosis.spawn.spawner.ApothSpawnerBlock;
import shadows.apotheosis.spawn.spawner.ApothSpawnerTile;

@WailaPlugin
public class SpawnerHwylaPlugin
implements IWailaPlugin,
IComponentProvider,
IServerDataProvider<TileEntity> {
    public static final String STATS = "spw_stats";

    public void register(IRegistrar reg) {
        reg.registerBlockDataProvider((IServerDataProvider)this, ApothSpawnerTile.class);
        reg.registerComponentProvider((IComponentProvider)this, TooltipPosition.BODY, ApothSpawnerBlock.class);
    }

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (Screen.func_231172_r_()) {
            int[] stats = accessor.getServerData().func_74759_k(STATS);
            if (stats.length != 12) {
                return;
            }
            tooltip.add(ApothSpawnerBlock.concat(SpawnerStats.MIN_DELAY.name(), stats[0]));
            tooltip.add(ApothSpawnerBlock.concat(SpawnerStats.MAX_DELAY.name(), stats[1]));
            tooltip.add(ApothSpawnerBlock.concat(SpawnerStats.SPAWN_COUNT.name(), stats[2]));
            tooltip.add(ApothSpawnerBlock.concat(SpawnerStats.MAX_NEARBY_ENTITIES.name(), stats[3]));
            tooltip.add(ApothSpawnerBlock.concat(SpawnerStats.REQ_PLAYER_RANGE.name(), stats[4]));
            tooltip.add(ApothSpawnerBlock.concat(SpawnerStats.SPAWN_RANGE.name(), stats[5]));
            if (stats[6] == 1) {
                tooltip.add((ITextComponent)SpawnerStats.IGNORE_PLAYERS.name().func_240699_a_(TextFormatting.DARK_GREEN));
            }
            if (stats[7] == 1) {
                tooltip.add((ITextComponent)SpawnerStats.IGNORE_CONDITIONS.name().func_240699_a_(TextFormatting.DARK_GREEN));
            }
            if (stats[8] == 1) {
                tooltip.add((ITextComponent)SpawnerStats.REDSTONE_CONTROL.name().func_240699_a_(TextFormatting.DARK_GREEN));
            }
            if (stats[9] == 1) {
                tooltip.add((ITextComponent)SpawnerStats.IGNORE_LIGHT.name().func_240699_a_(TextFormatting.DARK_GREEN));
            }
            if (stats[10] == 1) {
                tooltip.add((ITextComponent)SpawnerStats.NO_AI.name().func_240699_a_(TextFormatting.DARK_GREEN));
            }
            if (stats[11] == 1) {
                tooltip.add((ITextComponent)SpawnerStats.SILENT.name().func_240699_a_(TextFormatting.DARK_GREEN));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("misc.apotheosis.ctrl_stats"));
        }
    }

    public void appendServerData(CompoundNBT tag, ServerPlayerEntity player, World world, TileEntity te) {
        if (te instanceof ApothSpawnerTile) {
            ApothSpawnerTile spw = (ApothSpawnerTile)te;
            AbstractSpawner logic = spw.func_145881_a();
            tag.func_74783_a(STATS, new int[]{logic.field_98283_g, logic.field_98293_h, logic.field_98294_i, logic.field_98292_k, logic.field_98289_l, logic.field_98290_m, spw.ignoresPlayers ? 1 : 0, spw.ignoresConditions ? 1 : 0, spw.redstoneControl ? 1 : 0, spw.ignoresLight ? 1 : 0, spw.hasNoAI ? 1 : 0, spw.silent ? 1 : 0});
        }
    }
}

