/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.compat;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.plugins.vanilla.ingredients.item.ItemStackRenderer;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.apotheosis.spawn.modifiers.SpawnerModifier;
import shadows.apotheosis.spawn.modifiers.StatModifier;

public class SpawnerCategory
implements IRecipeCategory<SpawnerModifier> {
    public static final ResourceLocation TEXTURES = new ResourceLocation("apotheosis", "textures/gui/spawner_jei.png");
    public static final ResourceLocation UID = new ResourceLocation("apotheosis", "spawner_modifiers");
    private final IDrawable bg;
    private final IDrawable icon;
    private final ITextComponent title;
    private final ItemStackRenderer renderer;
    private final ItemStack spawner = new ItemStack((IItemProvider)Items.field_221671_bX);

    public SpawnerCategory(IGuiHelper helper) {
        this.bg = helper.drawableBuilder(TEXTURES, 0, 0, 168, 75).build();
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Items.field_221671_bX));
        this.title = new TranslationTextComponent("title.apotheosis.spawner");
        this.renderer = new ItemStackRenderer();
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public String getTitle() {
        return this.title.getString();
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public void setRecipe(IRecipeLayout layout, SpawnerModifier recipe, IIngredients ing) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        stacks.init(0, true, 10, 10);
        if (recipe.getOffhandInput() != Ingredient.field_193370_a) {
            stacks.init(1, true, 10, 47);
        }
        stacks.set(ing);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends SpawnerModifier> getRecipeClass() {
        return SpawnerModifier.class;
    }

    public void setIngredients(SpawnerModifier recipe, IIngredients ing) {
        ing.setInputIngredients(Arrays.asList(recipe.getMainhandInput(), recipe.getOffhandInput(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150474_ac})));
        ing.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)Blocks.field_150474_ac));
    }

    /*
     * Unable to fully structure code
     */
    public void draw(SpawnerModifier recipe, MatrixStack stack, double mouseX, double mouseY) {
        if (recipe.getOffhandInput() == Ingredient.field_193370_a) {
            Screen.func_238464_a_((MatrixStack)stack, (int)1, (int)31, (int)0, (float)0.0f, (float)88.0f, (int)28, (int)34, (int)256, (int)256);
        }
        if ((scn = Minecraft.func_71410_x().field_71462_r) == null) {
            return;
        }
        if (mouseX >= -1.0 && mouseX < 9.0 && mouseY >= 13.0 && mouseY < 25.0) {
            Screen.func_238464_a_((MatrixStack)stack, (int)-1, (int)13, (int)0, (float)0.0f, (float)75.0f, (int)10, (int)12, (int)256, (int)256);
            scn.func_243308_b(stack, Arrays.asList(new ITextComponent[]{new TranslationTextComponent("misc.apotheosis.mainhand")}), (int)mouseX, (int)mouseY);
        } else if (mouseX >= -1.0 && mouseX < 9.0 && mouseY >= 50.0 && mouseY < 62.0 && recipe.getOffhandInput() != Ingredient.field_193370_a) {
            Screen.func_238464_a_((MatrixStack)stack, (int)-1, (int)50, (int)0, (float)0.0f, (float)75.0f, (int)10, (int)12, (int)256, (int)256);
            scn.func_243308_b(stack, Arrays.asList(new ITextComponent[]{new TranslationTextComponent("misc.apotheosis.offhand"), new TranslationTextComponent("misc.apotheosis.not_consumed").func_240699_a_(TextFormatting.GRAY)}), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 33.0 && mouseX < 49.0 && mouseY >= 30.0 && mouseY < 46.0) {
            scn.func_243308_b(stack, Arrays.asList(new ITextComponent[]{new TranslationTextComponent("misc.apotheosis.rclick_spawner")}), (int)mouseX, (int)mouseY);
        }
        this.renderer.render(stack, 31, 29, this.spawner);
        font = Minecraft.func_71410_x().field_71466_p;
        v0 = recipe.getStatModifiers().size();
        font.getClass();
        top = 37 - v0 * (9 + 2) / 2 + 2;
        left = 168;
        for (StatModifier<?> s : recipe.getStatModifiers()) {
            value = s.value.toString();
            if (value.equals("true")) {
                value = "+";
            } else if (value.equals("false")) {
                value = "-";
            } else if (s.value instanceof Number && ((Number)s.value).intValue() > 0) {
                value = "+" + value;
            }
            msg = new TranslationTextComponent("misc.apotheosis.concat", new Object[]{value, s.stat.name()});
            width = font.func_238414_a_((ITextProperties)msg);
            if (!(mouseX >= (double)(left - width)) || !(mouseX < (double)left) || !(mouseY >= (double)top)) ** GOTO lbl-1000
            font.getClass();
            if (mouseY < (double)(top + 9 + 1)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            hover = v1;
            font.func_243248_b(stack, (ITextComponent)msg, (float)(left - font.func_238414_a_((ITextProperties)msg)), (float)top, hover != false ? 0x8080FF : 0x333333);
            maxWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
            maxWidth = maxWidth - (maxWidth - 210) / 2 - 210;
            if (hover) {
                list = new ArrayList<ITextComponent>();
                list.add((ITextComponent)s.stat.name().func_240701_a_(new TextFormatting[]{TextFormatting.GREEN, TextFormatting.UNDERLINE}));
                list.add((ITextComponent)s.stat.desc().func_240699_a_(TextFormatting.GRAY));
                if (s.value instanceof Number) {
                    if (((Number)s.min).intValue() > 0 || ((Number)s.max).intValue() != 0x7FFFFFFF) {
                        list.add((ITextComponent)new StringTextComponent(" "));
                    }
                    if (((Number)s.min).intValue() > 0) {
                        list.add((ITextComponent)new TranslationTextComponent("misc.apotheosis.min_value", new Object[]{s.min}).func_240699_a_(TextFormatting.GRAY));
                    }
                    if (((Number)s.max).intValue() != 0x7FFFFFFF) {
                        list.add((ITextComponent)new TranslationTextComponent("misc.apotheosis.max_value", new Object[]{s.max}).func_240699_a_(TextFormatting.GRAY));
                    }
                }
                SpawnerCategory.renderComponentTooltip(scn, stack, list, left + 6, (int)mouseY, maxWidth, font);
            }
            font.getClass();
            top += 9 + 2;
        }
    }

    private static void renderComponentTooltip(Screen scn, MatrixStack stack, List<ITextComponent> list, int x, int y, int maxWidth, FontRenderer font) {
        List text = list.stream().map(c -> font.func_238420_b_().func_238362_b_((ITextProperties)c, maxWidth, c.func_150256_b())).flatMap(Collection::stream).collect(Collectors.toList());
        scn.renderWrappedToolTip(stack, text, x, y, font);
    }
}

