/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.potion;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.table.EnchantingRecipe;
import shadows.apotheosis.ench.table.EnchantingStatManager;

public class PotionEnchantingRecipe
extends EnchantingRecipe {
    public static final Serializer SERIALIZER = new Serializer();

    public PotionEnchantingRecipe(EnchantingStatManager.Stats requirements, EnchantingStatManager.Stats maxRequirements) {
        super(new ResourceLocation("apotheosis", "potion_charm_enchanting"), PotionEnchantingRecipe.charm(), PotionEnchantingRecipe.potion(), requirements, maxRequirements);
    }

    private static ItemStack charm() {
        ItemStack out = new ItemStack((IItemProvider)ApotheosisObjects.POTION_CHARM);
        out.func_196082_o().func_74757_a("Unbreakable", true);
        return out;
    }

    private static Ingredient potion() {
        ArrayList<ItemStack> potionStacks = new ArrayList<ItemStack>();
        for (Potion p : ForgeRegistries.POTION_TYPES) {
            if (p.func_185170_a().size() != 1 || ((EffectInstance)p.func_185170_a().get(0)).func_188419_a().func_76403_b()) continue;
            ItemStack potion = new ItemStack((IItemProvider)ApotheosisObjects.POTION_CHARM);
            PotionUtils.func_185188_a((ItemStack)potion, (Potion)p);
            potionStacks.add(potion);
        }
        return Ingredient.func_193369_a((ItemStack[])potionStacks.toArray(new ItemStack[0]));
    }

    @Override
    public boolean matches(ItemStack input, float eterna, float quanta, float arcana) {
        if (input.func_77942_o() && input.func_77978_p().func_74767_n("Unbreakable")) {
            return false;
        }
        return super.matches(input, eterna, quanta, arcana);
    }

    @Override
    public ItemStack assemble(ItemStack input, float eterna, float quanta, float arcana) {
        ItemStack out = input.func_77946_l();
        out.func_196085_b(0);
        out.func_196082_o().func_74757_a("Unbreakable", true);
        return out;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PotionEnchantingRecipe> {
        protected static final Gson GSON = new GsonBuilder().create();

        public PotionEnchantingRecipe fromJson(ResourceLocation id, JsonObject obj) {
            EnchantingStatManager.Stats maxStats;
            EnchantingStatManager.Stats stats = (EnchantingStatManager.Stats)GSON.fromJson(obj.get("requirements"), EnchantingStatManager.Stats.class);
            EnchantingStatManager.Stats stats2 = maxStats = obj.has("max_requirements") ? (EnchantingStatManager.Stats)GSON.fromJson(obj.get("max_requirements"), EnchantingStatManager.Stats.class) : EnchantingRecipe.NO_MAX;
            if (maxStats.eterna != -1.0f && stats.eterna > maxStats.eterna) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max eterna bounds (min > max).");
            }
            if (maxStats.quanta != -1.0f && stats.quanta > maxStats.quanta) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max quanta bounds (min > max).");
            }
            if (maxStats.arcana != -1.0f && stats.arcana > maxStats.arcana) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max arcana bounds (min > max).");
            }
            return new PotionEnchantingRecipe(stats, maxStats);
        }

        public PotionEnchantingRecipe fromNetwork(ResourceLocation id, PacketBuffer buf) {
            EnchantingStatManager.Stats stats = EnchantingStatManager.Stats.read(buf);
            EnchantingStatManager.Stats maxStats = buf.readBoolean() ? EnchantingStatManager.Stats.read(buf) : EnchantingRecipe.NO_MAX;
            return new PotionEnchantingRecipe(stats, maxStats);
        }

        public void toNetwork(PacketBuffer buf, PotionEnchantingRecipe recipe) {
            recipe.requirements.write(buf);
            buf.writeBoolean(recipe.maxRequirements != EnchantingRecipe.NO_MAX);
            if (recipe.maxRequirements != EnchantingRecipe.NO_MAX) {
                recipe.maxRequirements.write(buf);
            }
        }
    }
}

