/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import shadows.apotheosis.ench.asm.EnchHooks;
import shadows.apotheosis.ench.table.ApothEnchantContainer;
import shadows.apotheosis.ench.table.EnchantingStatManager;
import shadows.apotheosis.ench.table.IEnchantableItem;

public class RealEnchantmentHelper {
    public static int getEnchantmentCost(Random rand, int num, float eterna, ItemStack stack) {
        int ench = stack.getItemEnchantability();
        if (ench <= 0) {
            return 0;
        }
        int level = Math.round(eterna * 2.0f);
        if (num == 2) {
            return level;
        }
        float lowBound = 0.6f - 0.4f * (float)(1 - num);
        float highBound = 0.8f - 0.4f * (float)(1 - num);
        return Math.max(1, Math.round((float)level * MathHelper.func_151240_a((Random)rand, (float)lowBound, (float)highBound)));
    }

    public static List<EnchantmentData> selectEnchantment(Random rand, ItemStack stack, int level, float quanta, float arcana, float rectification, boolean treasure) {
        ArrayList chosenEnchants = Lists.newArrayList();
        int enchantability = stack.getItemEnchantability();
        int srcLevel = level;
        if (enchantability > 0) {
            float quantaFactor = 1.0f + MathHelper.func_151240_a((Random)rand, (float)(-1.0f + rectification / 100.0f), (float)1.0f) * quanta / 100.0f;
            level = MathHelper.func_76125_a((int)Math.round((float)level * quantaFactor), (int)1, (int)((int)(EnchantingStatManager.getAbsoluteMaxEterna() * 4.0f)));
            ApothEnchantContainer.Arcana arcanaVals = ApothEnchantContainer.Arcana.getForThreshold(arcana);
            List<EnchantmentData> allEnchants = RealEnchantmentHelper.getAvailableEnchantmentResults(level, stack, treasure);
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
            allEnchants.removeIf(e -> enchants.containsKey(e.field_76302_b));
            List<ArcanaEnchantmentData> possibleEnchants = allEnchants.stream().map(d -> new ArcanaEnchantmentData(arcanaVals, (EnchantmentData)d)).collect(Collectors.toList());
            if (!possibleEnchants.isEmpty()) {
                chosenEnchants.add(((ArcanaEnchantmentData)WeightedRandom.func_76271_a((Random)rand, possibleEnchants)).data);
                RealEnchantmentHelper.removeIncompatible(possibleEnchants, (EnchantmentData)Util.func_223378_a((List)chosenEnchants));
                if (arcana >= 25.0f && !possibleEnchants.isEmpty()) {
                    chosenEnchants.add(((ArcanaEnchantmentData)WeightedRandom.func_76271_a((Random)rand, possibleEnchants)).data);
                    RealEnchantmentHelper.removeIncompatible(possibleEnchants, (EnchantmentData)Util.func_223378_a((List)chosenEnchants));
                }
                if (arcana >= 75.0f && !possibleEnchants.isEmpty()) {
                    chosenEnchants.add(((ArcanaEnchantmentData)WeightedRandom.func_76271_a((Random)rand, possibleEnchants)).data);
                }
                int randomBound = 50;
                if (level > 45) {
                    level = (int)((float)srcLevel * 1.15f);
                }
                while (rand.nextInt(randomBound) <= level) {
                    if (!chosenEnchants.isEmpty()) {
                        RealEnchantmentHelper.removeIncompatible(possibleEnchants, (EnchantmentData)Util.func_223378_a((List)chosenEnchants));
                    }
                    if (possibleEnchants.isEmpty()) break;
                    chosenEnchants.add(((ArcanaEnchantmentData)WeightedRandom.func_76271_a((Random)rand, possibleEnchants)).data);
                    level /= 2;
                }
            }
        }
        return ((IEnchantableItem)stack.func_77973_b()).selectEnchantments(chosenEnchants, rand, stack, srcLevel, quanta, arcana, treasure);
    }

    public static void removeIncompatible(List<ArcanaEnchantmentData> list, EnchantmentData data) {
        Iterator<ArcanaEnchantmentData> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (data.field_76302_b.func_191560_c(iterator.next().data.field_76302_b)) continue;
            iterator.remove();
        }
    }

    public static List<EnchantmentData> getAvailableEnchantmentResults(int power, ItemStack stack, boolean allowTreasure) {
        return EnchHooks.getEnchantmentDatas(power, stack, allowTreasure);
    }

    public static class ArcanaEnchantmentData
    extends WeightedRandom.Item {
        EnchantmentData data;

        public ArcanaEnchantmentData(ApothEnchantContainer.Arcana arcana, EnchantmentData data) {
            super(arcana.getRarities()[data.field_76302_b.func_77324_c().ordinal()]);
            this.data = data;
        }
    }
}

