/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.library;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.library.EnchLibraryContainer;
import shadows.placebo.recipe.VanillaPacketDispatcher;

public abstract class EnchLibraryTile
extends TileEntity {
    protected final Object2IntMap<Enchantment> points = new Object2IntOpenHashMap();
    protected final Object2IntMap<Enchantment> maxLevels = new Object2IntOpenHashMap();
    protected final Set<EnchLibraryContainer> activeContainers = new HashSet<EnchLibraryContainer>();
    protected final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new EnchLibItemHandler());
    protected final int maxLevel;
    protected final int maxPoints;

    public EnchLibraryTile(TileEntityType<?> type, int maxLevel) {
        super(type);
        this.maxLevel = maxLevel;
        this.maxPoints = EnchLibraryTile.levelToPoints(maxLevel);
    }

    public void depositBook(ItemStack book) {
        if (book.func_77973_b() != Items.field_151134_bR) {
            return;
        }
        Map enchs = EnchantmentHelper.func_82781_a((ItemStack)book);
        for (Map.Entry e : enchs.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            int newPoints = Math.min(this.maxPoints, this.points.getInt(e.getKey()) + EnchLibraryTile.levelToPoints((Integer)e.getValue()));
            if (newPoints < 0) {
                newPoints = this.maxPoints;
            }
            this.points.put(e.getKey(), newPoints);
            this.maxLevels.put(e.getKey(), Math.min(this.maxLevel, Math.max(this.maxLevels.getInt(e.getKey()), (Integer)e.getValue())));
        }
        if (enchs.size() > 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
        }
        this.func_70296_d();
    }

    public void extractEnchant(ItemStack stack, Enchantment ench, int level) {
        int curLvl = EnchantmentHelper.func_82781_a((ItemStack)stack).getOrDefault(ench, 0);
        if (stack.func_190926_b() || !this.canExtract(ench, level, curLvl) || level == curLvl) {
            return;
        }
        Map enchs = EnchantmentHelper.func_82781_a((ItemStack)stack);
        enchs.put(ench, level);
        EnchantmentHelper.func_82782_a((Map)enchs, (ItemStack)stack);
        this.points.put((Object)ench, Math.max(0, this.points.getInt((Object)ench) - EnchLibraryTile.levelToPoints(level) + EnchLibraryTile.levelToPoints(curLvl)));
        if (!this.field_145850_b.func_201670_d()) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
        }
        this.func_70296_d();
    }

    public boolean canExtract(Enchantment ench, int level, int currentLevel) {
        return this.maxLevels.getInt((Object)ench) >= level && this.points.getInt((Object)ench) >= EnchLibraryTile.levelToPoints(level) - EnchLibraryTile.levelToPoints(currentLevel);
    }

    public static int levelToPoints(int level) {
        return (int)Math.pow(2.0, level - 1);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT points = new CompoundNBT();
        for (Object2IntMap.Entry e : this.points.object2IntEntrySet()) {
            points.func_74768_a(((Enchantment)e.getKey()).getRegistryName().toString(), e.getIntValue());
        }
        tag.func_218657_a("Points", (INBT)points);
        CompoundNBT levels = new CompoundNBT();
        for (Object2IntMap.Entry e : this.maxLevels.object2IntEntrySet()) {
            levels.func_74768_a(((Enchantment)e.getKey()).getRegistryName().toString(), e.getIntValue());
        }
        tag.func_218657_a("Levels", (INBT)levels);
        return super.func_189515_b(tag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        CompoundNBT points = tag.func_74775_l("Points");
        for (String s : points.func_150296_c()) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ench == null) continue;
            this.points.put((Object)ench, points.func_74762_e(s));
        }
        CompoundNBT levels = tag.func_74775_l("Levels");
        for (String s : levels.func_150296_c()) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ench == null) continue;
            this.maxLevels.put((Object)ench, levels.func_74762_e(s));
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        CompoundNBT points = tag.func_74775_l("Points");
        for (String s : points.func_150296_c()) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ench == null) continue;
            this.points.put((Object)ench, points.func_74762_e(s));
        }
        CompoundNBT levels = tag.func_74775_l("Levels");
        for (String s : levels.func_150296_c()) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ench == null) continue;
            this.maxLevels.put((Object)ench, levels.func_74762_e(s));
        }
        this.activeContainers.forEach(EnchLibraryContainer::onChanged);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -12, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        CompoundNBT points = new CompoundNBT();
        for (Object2IntMap.Entry e : this.points.object2IntEntrySet()) {
            points.func_74768_a(((Enchantment)e.getKey()).getRegistryName().toString(), e.getIntValue());
        }
        tag.func_218657_a("Points", (INBT)points);
        CompoundNBT levels = new CompoundNBT();
        for (Object2IntMap.Entry e : this.maxLevels.object2IntEntrySet()) {
            levels.func_74768_a(((Enchantment)e.getKey()).getRegistryName().toString(), e.getIntValue());
        }
        tag.func_218657_a("Levels", (INBT)levels);
        return tag;
    }

    public Object2IntMap<Enchantment> getPointsMap() {
        return this.points;
    }

    public Object2IntMap<Enchantment> getLevelsMap() {
        return this.maxLevels;
    }

    public void addListener(EnchLibraryContainer ctr) {
        this.activeContainers.add(ctr);
    }

    public void removeListener(EnchLibraryContainer ctr) {
        this.activeContainers.remove((Object)ctr);
    }

    public int getMax(Enchantment ench) {
        return Math.min(this.maxLevel, this.maxLevels.getInt((Object)ench));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public static class EnderLibraryTile
    extends EnchLibraryTile {
        public EnderLibraryTile() {
            super(ApotheosisObjects.ENDER_LIB_TILE, 31);
        }
    }

    public static class BasicLibraryTile
    extends EnchLibraryTile {
        public BasicLibraryTile() {
            super(ApotheosisObjects.ENCH_LIB_TILE, 16);
        }
    }

    private class EnchLibItemHandler
    implements IItemHandler {
        private EnchLibItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_77973_b() != Items.field_151134_bR || stack.func_190916_E() > 1) {
                return stack;
            }
            if (!simulate) {
                EnchLibraryTile.this.depositBook(stack);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0 && stack.func_77973_b() == Items.field_151134_bR;
        }
    }
}

