/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.enchantments;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BlockEvent;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.util.BlockUtil;
import shadows.placebo.util.PlaceboTaskQueue;

public class ChainsawEnchant
extends Enchantment {
    public ChainsawEnchant() {
        super(Enchantment.Rarity.VERY_RARE, EnchModule.AXE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int level) {
        return 55;
    }

    public int func_223551_b(int enchantmentLevel) {
        return 200;
    }

    public ITextComponent func_200305_d(int level) {
        return ((IFormattableTextComponent)super.func_200305_d(level)).func_240699_a_(TextFormatting.DARK_GREEN);
    }

    public void chainsaw(BlockEvent.BreakEvent e) {
        PlayerEntity player = e.getPlayer();
        World level = player.field_70170_p;
        ItemStack stack = player.func_184614_ca();
        int enchLevel = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (player.getClass() == ServerPlayerEntity.class && enchLevel > 0 && !level.field_72995_K && this.isTree(level, e.getPos(), e.getState()) && !player.field_71075_bZ.field_75098_d) {
            PlaceboTaskQueue.submitTask((String)"apotheosis:chainsaw_task", (BooleanSupplier)new ChainsawTask(player.func_110124_au(), stack, level, e.getPos()));
        }
    }

    private boolean isTree(World level, BlockPos pos, BlockState state) {
        if (!state.func_235714_a_((ITag)BlockTags.field_200031_h)) {
            return false;
        }
        while (state.func_235714_a_((ITag)BlockTags.field_200031_h)) {
            pos = pos.func_177984_a();
            state = level.func_180495_p(pos);
        }
        for (BlockPos p : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, -2, -2), (BlockPos)pos.func_177982_a(2, 2, 2))) {
            if (!level.func_180495_p(p).func_235714_a_((ITag)BlockTags.field_206952_E)) continue;
            return true;
        }
        return false;
    }

    private static class ChainsawTask
    implements BooleanSupplier {
        UUID owner;
        ItemStack axe;
        ServerWorld level;
        Int2ObjectMap<Queue<BlockPos>> hits = new Int2ObjectOpenHashMap();
        int ticks = 0;

        public ChainsawTask(UUID owner, ItemStack axe, World level, BlockPos pos) {
            this.owner = owner;
            this.axe = axe;
            this.level = (ServerWorld)level;
            ((Queue)this.hits.computeIfAbsent(pos.func_177956_o(), i -> new ArrayDeque())).add(pos);
        }

        @Override
        public boolean getAsBoolean() {
            if (++this.ticks % 2 != 0) {
                return false;
            }
            if (this.axe.func_190926_b()) {
                return true;
            }
            int minY = (Integer)this.hits.keySet().stream().sorted().findFirst().orElseThrow(() -> new RuntimeException());
            Queue queue = (Queue)this.hits.remove(minY);
            while (!queue.isEmpty()) {
                BlockPos pos = (BlockPos)queue.poll();
                for (BlockPos p : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
                    BlockState state = this.level.func_180495_p(p);
                    if (!state.func_235714_a_((ITag)BlockTags.field_200031_h)) continue;
                    BlockUtil.breakExtraBlock(this.level, p, this.axe, this.owner);
                    ((Queue)this.hits.computeIfAbsent(p.func_177956_o(), i -> new ArrayDeque())).add(p.func_185334_h());
                }
            }
            return this.hits.isEmpty();
        }
    }
}

