/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.compat;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnchantmentNameParts;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.table.EnchantingRecipe;
import shadows.apotheosis.ench.table.EnchantingStatManager;

public class EnchantingCategory
implements IRecipeCategory<EnchantingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("apotheosis", "enchanting");
    public static final ResourceLocation TEXTURES = new ResourceLocation("apotheosis", "textures/gui/enchanting_jei.png");
    private static final Map<Class<?>, Extension<?>> EXTENSIONS = new HashMap();
    private final IDrawable background;
    private final IDrawable icon;
    private final TranslationTextComponent localizedName;

    public EnchantingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURES, 0, 0, 170, 56);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Blocks.field_150381_bn));
        this.localizedName = new TranslationTextComponent("apotheosis.recipes.enchanting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<EnchantingRecipe> getRecipeClass() {
        return EnchantingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName.getString();
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(EnchantingRecipe recipe, IIngredients ing) {
        Extension<?> ext = EXTENSIONS.get(recipe.getClass());
        if (ext != null) {
            ext.setIngredients(recipe, ing);
        } else {
            ing.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
            ing.setInputIngredients(Arrays.asList(recipe.getInput()));
        }
    }

    public void setRecipe(IRecipeLayout layout, EnchantingRecipe recipe, IIngredients ing) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        stacks.init(0, true, 5, 5);
        stacks.init(1, false, 36, 5);
        Extension<?> ext = EXTENSIONS.get(recipe.getClass());
        if (ext != null) {
            ext.setRecipe(recipe, layout, ing);
        } else {
            stacks.set(ing);
        }
    }

    public void draw(EnchantingRecipe recipe, MatrixStack stack, double mouseX, double mouseY) {
        boolean hover = false;
        if (mouseX > 57.0 && mouseX <= 165.0 && mouseY > 4.0 && mouseY <= 23.0) {
            Screen.func_238464_a_((MatrixStack)stack, (int)57, (int)4, (int)0, (float)0.0f, (float)71.0f, (int)108, (int)19, (int)256, (int)256);
            hover = true;
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        EnchantingStatManager.Stats stats = recipe.getRequirements();
        EnchantingStatManager.Stats maxStats = recipe.getMaxRequirements();
        font.func_238421_b_(stack, I18n.func_135052_a((String)"gui.apotheosis.enchant.eterna", (Object[])new Object[0]), 16.0f, 26.0f, 4044093);
        font.func_238421_b_(stack, I18n.func_135052_a((String)"gui.apotheosis.enchant.quanta", (Object[])new Object[0]), 16.0f, 36.0f, 16536660);
        font.func_238421_b_(stack, I18n.func_135052_a((String)"gui.apotheosis.enchant.arcana", (Object[])new Object[0]), 16.0f, 46.0f, 0xA800A8);
        int level = (int)(stats.eterna * 2.0f);
        String s = "" + level;
        int width = 86 - font.func_78256_a(s);
        EnchantmentNameParts.func_178176_a().func_148335_a((long)recipe.func_199560_c().hashCode());
        ITextProperties itextproperties = EnchantmentNameParts.func_178176_a().func_238816_a_(font, width);
        int color = hover ? 0xFFFF80 : 6839882;
        EnchantingCategory.drawWordWrap(font, itextproperties, 77, 6, width, color, stack);
        color = 8453920;
        font.func_238405_a_(stack, s, (float)(77 + width), 13.0f, color);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURES);
        int[] pos = new int[]{(int)(stats.eterna / EnchantingStatManager.getAbsoluteMaxEterna() * 110.0f), (int)(stats.quanta / 100.0f * 110.0f), (int)(stats.arcana / 100.0f * 110.0f)};
        if (stats.eterna > 0.0f) {
            Screen.func_238463_a_((MatrixStack)stack, (int)56, (int)27, (float)0.0f, (float)56.0f, (int)pos[0], (int)5, (int)256, (int)256);
        }
        if (stats.quanta > 0.0f) {
            Screen.func_238463_a_((MatrixStack)stack, (int)56, (int)37, (float)0.0f, (float)61.0f, (int)pos[1], (int)5, (int)256, (int)256);
        }
        if (stats.arcana > 0.0f) {
            Screen.func_238463_a_((MatrixStack)stack, (int)56, (int)47, (float)0.0f, (float)66.0f, (int)pos[2], (int)5, (int)256, (int)256);
        }
        RenderSystem.enableBlend();
        if (maxStats.eterna > 0.0f) {
            Screen.func_238463_a_((MatrixStack)stack, (int)(56 + pos[0]), (int)27, (float)pos[0], (float)90.0f, (int)((int)((maxStats.eterna - stats.eterna) / EnchantingStatManager.getAbsoluteMaxEterna() * 110.0f)), (int)5, (int)256, (int)256);
        }
        if (maxStats.quanta > 0.0f) {
            Screen.func_238463_a_((MatrixStack)stack, (int)(56 + pos[1]), (int)37, (float)pos[1], (float)95.0f, (int)((int)((maxStats.quanta - stats.quanta) / 100.0f * 110.0f)), (int)5, (int)256, (int)256);
        }
        if (maxStats.arcana > 0.0f) {
            Screen.func_238463_a_((MatrixStack)stack, (int)(56 + pos[2]), (int)47, (float)pos[2], (float)100.0f, (int)((int)((maxStats.arcana - stats.arcana) / 100.0f * 110.0f)), (int)5, (int)256, (int)256);
        }
        RenderSystem.disableBlend();
        Screen scn = Minecraft.func_71410_x().field_71462_r;
        if (scn == null) {
            return;
        }
        if (hover) {
            ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
            list.add(new TranslationTextComponent("container.enchant.clue", new Object[]{ApotheosisObjects.INFUSION.func_200305_d(1).getString()}).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
            scn.func_243308_b(stack, list, (int)mouseX, (int)mouseY);
        } else if (mouseX > 56.0 && mouseX <= 166.0 && mouseY > 26.0 && mouseY <= 32.0) {
            ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
            list.add(new TranslationTextComponent("gui.apotheosis.enchant.eterna").func_240699_a_(TextFormatting.GREEN));
            if (maxStats.eterna == stats.eterna) {
                list.add(new TranslationTextComponent("info.apotheosis.eterna_exact", new Object[]{Float.valueOf(stats.eterna), Float.valueOf(EnchantingStatManager.getAbsoluteMaxEterna())}).func_240699_a_(TextFormatting.GRAY));
            } else {
                list.add(new TranslationTextComponent("info.apotheosis.eterna_at_least", new Object[]{Float.valueOf(stats.eterna), Float.valueOf(EnchantingStatManager.getAbsoluteMaxEterna())}).func_240699_a_(TextFormatting.GRAY));
                if (maxStats.eterna > -1.0f) {
                    list.add(new TranslationTextComponent("info.apotheosis.eterna_at_most", new Object[]{Float.valueOf(maxStats.eterna), Float.valueOf(EnchantingStatManager.getAbsoluteMaxEterna())}).func_240699_a_(TextFormatting.GRAY));
                }
            }
            scn.func_243308_b(stack, list, (int)mouseX, (int)mouseY);
        } else if (mouseX > 56.0 && mouseX <= 166.0 && mouseY > 36.0 && mouseY <= 42.0) {
            ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
            list.add(new TranslationTextComponent("gui.apotheosis.enchant.quanta").func_240699_a_(TextFormatting.RED));
            if (maxStats.quanta == stats.quanta) {
                list.add(new TranslationTextComponent("info.apotheosis.percent_exact", new Object[]{Float.valueOf(stats.quanta)}).func_240699_a_(TextFormatting.GRAY));
            } else {
                list.add(new TranslationTextComponent("info.apotheosis.percent_at_least", new Object[]{Float.valueOf(stats.quanta)}).func_240699_a_(TextFormatting.GRAY));
                if (maxStats.quanta > -1.0f) {
                    list.add(new TranslationTextComponent("info.apotheosis.percent_at_most", new Object[]{Float.valueOf(maxStats.quanta)}).func_240699_a_(TextFormatting.GRAY));
                }
            }
            scn.func_243308_b(stack, list, (int)mouseX, (int)mouseY);
        } else if (mouseX > 56.0 && mouseX <= 166.0 && mouseY > 46.0 && mouseY <= 52.0) {
            ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
            list.add(new TranslationTextComponent("gui.apotheosis.enchant.arcana").func_240699_a_(TextFormatting.DARK_PURPLE));
            if (maxStats.arcana == stats.arcana) {
                list.add(new TranslationTextComponent("info.apotheosis.percent_exact", new Object[]{Float.valueOf(stats.arcana)}).func_240699_a_(TextFormatting.GRAY));
            } else {
                list.add(new TranslationTextComponent("info.apotheosis.percent_at_least", new Object[]{Float.valueOf(stats.arcana)}).func_240699_a_(TextFormatting.GRAY));
                if (maxStats.arcana > -1.0f) {
                    list.add(new TranslationTextComponent("info.apotheosis.percent_at_most", new Object[]{Float.valueOf(maxStats.arcana)}).func_240699_a_(TextFormatting.GRAY));
                }
            }
            scn.func_243308_b(stack, list, (int)mouseX, (int)mouseY);
        }
    }

    public static void drawWordWrap(FontRenderer font, ITextProperties pText, int pX, int pY, int pMaxWidth, int pColor, MatrixStack stack) {
        for (IReorderingProcessor formattedcharsequence : font.func_238425_b_(pText, pMaxWidth)) {
            font.func_238422_b_(stack, formattedcharsequence, (float)pX, (float)pY, pColor);
            pY += 9;
        }
    }

    public static <T extends EnchantingRecipe> void registerExtension(Class<T> cls, Extension<T> ext) {
        EXTENSIONS.put(cls, ext);
    }

    public static interface Extension<T extends EnchantingRecipe> {
        public void setIngredients(T var1, IIngredients var2);

        public void setRecipe(T var1, IRecipeLayout var2, IIngredients var3);
    }
}

