/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.reload;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.coremod.api.ASMAPI;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.gen.BossItem;
import shadows.apotheosis.util.AxisAlignedBBDeserializer;
import shadows.apotheosis.util.ChancedEffectInstance;
import shadows.apotheosis.util.EntityTypeDeserializer;
import shadows.apotheosis.util.GearSet;
import shadows.apotheosis.util.JsonUtil;
import shadows.apotheosis.util.RandomAttributeModifier;
import shadows.placebo.util.json.NBTAdapter;

public class BossItemManager
extends JsonReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(EntityType.class, (Object)new EntityTypeDeserializer()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(GearSet.SetPredicate.class, (Object)new GearSet.SetPredicateAdapter()).setFieldNamingStrategy(f -> f.getName().equals(ASMAPI.mapField((String)"field_76292_a")) ? "weight" : f.getName()).registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(ChancedEffectInstance.class, (Object)new ChancedEffectInstance.Deserializer()).registerTypeAdapter(RandomAttributeModifier.class, (Object)new RandomAttributeModifier.Deserializer()).registerTypeAdapter(AxisAlignedBB.class, (Object)new AxisAlignedBBDeserializer()).registerTypeAdapter(CompoundNBT.class, (Object)new NBTAdapter()).create();
    public static final BossItemManager INSTANCE = new BossItemManager();
    private final List<BossItem> entries = new ArrayList<BossItem>();
    private final Map<ResourceLocation, BossItem> registry = new HashMap<ResourceLocation, BossItem>();
    private volatile int weight = 0;

    public BossItemManager() {
        super(GSON, "bosses");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        this.entries.clear();
        this.registry.clear();
        for (Map.Entry<ResourceLocation, JsonElement> obj : objects.entrySet()) {
            try {
                if (JsonUtil.checkAndLogEmpty(obj.getValue(), obj.getKey(), "Boss", DeadlyModule.LOGGER)) continue;
                this.register(obj.getKey(), (BossItem)((Object)GSON.fromJson(obj.getValue(), BossItem.class)));
            }
            catch (Exception e) {
                DeadlyModule.LOGGER.error("Failed to load boss item {}.", (Object)obj.getKey());
                e.printStackTrace();
            }
        }
        if (this.entries.size() == 0) {
            throw new RuntimeException("No Bosses were registered.  This is not supported.");
        }
        Collections.shuffle(this.entries);
        this.weight = WeightedRandom.func_76272_a(this.entries);
        if (this.weight == 0) {
            throw new RuntimeException("The total boss weight is zero.  This is not supported.");
        }
        DeadlyModule.LOGGER.info("Loaded {} boss items from resources.", (Object)this.entries.size());
    }

    protected void register(ResourceLocation id, BossItem item) {
        if (!this.registry.containsKey(id)) {
            item.setId(id);
            this.registry.put(id, item);
            this.entries.add(item);
        } else {
            DeadlyModule.LOGGER.error("Attempted to register a boss item with name {}, but it already exists!", (Object)id);
        }
    }

    public BossItem getRandomItem(Random rand) {
        return (BossItem)WeightedRandom.func_76273_a((Random)rand, this.entries, (int)this.weight);
    }

    @Nullable
    public BossItem getById(ResourceLocation id) {
        return this.registry.get(id);
    }
}

