/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import shadows.apotheosis.deadly.DeadlyLoot;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.util.SpawnerStats;
import shadows.placebo.util.ChestBuilder;
import shadows.placebo.util.SpawnerEditor;

public class SpawnerItem
extends WeightedRandom.Item {
    public static final Block[] FILLER_BLOCKS = new Block[]{Blocks.field_196700_dk, Blocks.field_150341_Y, Blocks.field_235399_ni_, Blocks.field_235405_no_};
    protected final SpawnerStats stats;
    @SerializedName(value="spawn_potentials")
    protected final List<WeightedSpawnerEntity> spawnPotentials;
    @SerializedName(value="loot_table")
    protected final ResourceLocation lootTable;

    public SpawnerItem(SpawnerStats stats, ResourceLocation lootTable, List<WeightedSpawnerEntity> potentials, int weight) {
        super(weight);
        this.stats = stats;
        this.lootTable = lootTable;
        this.spawnPotentials = potentials;
    }

    public void place(IServerWorld world, BlockPos pos, Random rand) {
        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
        SpawnerEditor editor = new SpawnerEditor((IWorld)world, pos);
        this.stats.apply(editor).setSpawnData(this.spawnPotentials.get(rand.nextInt(this.spawnPotentials.size()))).setPotentials(this.spawnPotentials.toArray(new WeightedSpawnerEntity[0]));
        int chance = DeadlyConfig.spawnerValueChance;
        ChestBuilder.place((IWorld)world, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(chance > 0 && rand.nextInt(chance) == 0 ? DeadlyLoot.VALUABLE : this.lootTable));
        world.func_180501_a(pos.func_177984_a(), FILLER_BLOCKS[rand.nextInt(FILLER_BLOCKS.length)].func_176223_P(), 2);
        for (Direction f : Direction.Plane.HORIZONTAL) {
            if (!world.func_180495_p(pos.func_177972_a(f)).isAir((IBlockReader)world, pos.func_177972_a(f))) continue;
            BooleanProperty side = (BooleanProperty)Blocks.field_150395_bd.func_176194_O().func_185920_a(f.func_176734_d().func_176742_j());
            world.func_180501_a(pos.func_177972_a(f), (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)side, (Comparable)Boolean.valueOf(true)), 2);
        }
    }
}

