/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.reload.RandomSpawnerManager;

public class RogueSpawnerFeature
extends Feature<NoFeatureConfig> {
    public static final RogueSpawnerFeature INSTANCE = new RogueSpawnerFeature();
    public static final Predicate<BlockState> STONE_TEST = b -> OreFeatureConfig.FillerBlockType.field_241882_a.func_215181_a(b, null);

    public RogueSpawnerFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean place(ISeedReader world, ChunkGenerator gen, Random rand, BlockPos pos, NoFeatureConfig cfg) {
        if (!DeadlyConfig.canGenerateIn(world)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        BlockState downState = world.func_180495_p(pos.func_177977_b());
        BlockState upState = world.func_180495_p(pos.func_177984_a());
        if (STONE_TEST.test(downState) && upState.isAir((IBlockReader)world, pos.func_177984_a()) && (state.isAir((IBlockReader)world, pos) || STONE_TEST.test(state))) {
            RandomSpawnerManager.INSTANCE.getRandomItem(rand).place((IServerWorld)world, pos, rand);
            DeadlyModule.debugLog(pos, "Rogue Spawner");
            return true;
        }
        return false;
    }
}

