/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.affix.impl.heavy;

import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.apotheosis.deadly.affix.EquipmentType;
import shadows.apotheosis.deadly.affix.impl.RangedAffix;
import shadows.apotheosis.deadly.affix.modifiers.AffixModifier;

public class ExecuteAffix
extends RangedAffix {
    private static final DamageSource EXECUTION = new DamageSource("apoth.execute").func_76359_i().func_151518_m();

    public ExecuteAffix(int weight) {
        super(0.05f, 0.1f, weight);
    }

    @Override
    public boolean canApply(EquipmentType type) {
        return type == EquipmentType.AXE;
    }

    @Override
    public void onEntityDamaged(LivingEntity user, Entity target, float level) {
        LivingEntity living;
        if (target instanceof LivingEntity && (living = (LivingEntity)target).func_110143_aJ() / living.func_110138_aP() < level) {
            living.func_70645_a(EXECUTION);
        }
    }

    @Override
    public float generateLevel(ItemStack stack, Random rand, @Nullable AffixModifier modifier) {
        float lvl = this.range.func_186507_b(rand);
        if (modifier != null) {
            lvl = modifier.editLevel(this, lvl);
        }
        return lvl;
    }

    @Override
    public void addInformation(ItemStack stack, float level, Consumer<ITextComponent> list) {
        list.accept((ITextComponent)ExecuteAffix.loreComponent("affix." + this.getRegistryName() + ".desc", ExecuteAffix.fmt(level * 100.0f)));
    }

    @Override
    public ITextComponent getDisplayName(float level) {
        return new TranslationTextComponent("affix." + this.getRegistryName() + ".name", new Object[]{ExecuteAffix.fmt(level * 100.0f)}).func_240699_a_(TextFormatting.GRAY);
    }

    @Override
    public float getMin() {
        return 0.03f;
    }

    @Override
    public float getMax() {
        return 0.2f;
    }
}

