/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.affix;

import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import shadows.apotheosis.deadly.affix.EquipmentType;
import shadows.apotheosis.deadly.affix.modifiers.AffixModifier;
import shadows.placebo.config.Configuration;

public abstract class Affix
extends WeightedRandom.Item
implements IForgeRegistryEntry<Affix> {
    public static final ForgeRegistry<Affix> REGISTRY;
    public static Configuration config;
    protected ResourceLocation name;

    public Affix(int weight) {
        super(weight);
    }

    public abstract float generateLevel(ItemStack var1, Random var2, @Nullable AffixModifier var3);

    public void addModifiers(ItemStack stack, float level, EquipmentSlotType type, BiConsumer<Attribute, AttributeModifier> map) {
    }

    public void addInformation(ItemStack stack, float level, Consumer<ITextComponent> list) {
        list.accept((ITextComponent)Affix.loreComponent("affix." + this.getRegistryName() + ".desc", Affix.fmt(level)));
    }

    public ITextComponent chainName(ITextComponent name, @Nullable AffixModifier modifier) {
        return new TranslationTextComponent("affix." + this.name + (modifier != null && modifier.editName() ? "." + modifier.getKey() : ""), new Object[]{name});
    }

    public int getProtectionLevel(float level, DamageSource source) {
        return 0;
    }

    public float getExtraDamageFor(float level, CreatureAttribute creatureType) {
        return 0.0f;
    }

    public void onEntityDamaged(LivingEntity user, @Nullable Entity target, float level) {
    }

    public void onUserHurt(LivingEntity user, @Nullable Entity attacker, float level) {
    }

    public void onArrowFired(LivingEntity user, AbstractArrowEntity arrow, ItemStack bow, float level) {
    }

    @Nullable
    public ActionResultType onItemUse(ItemUseContext ctx, float level) {
        return null;
    }

    public void onArrowImpact(AbstractArrowEntity arrow, RayTraceResult res, RayTraceResult.Type type, float level) {
    }

    public float onShieldBlock(LivingEntity entity, ItemStack stack, DamageSource source, float amount, float level) {
        return amount;
    }

    public Affix setRegistryName(ResourceLocation name) {
        if (this.name == null) {
            this.name = name;
        }
        return this;
    }

    public Affix setRegistryName(String name) {
        return this.setRegistryName(GameData.checkPrefix((String)name, (boolean)false));
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<Affix> getRegistryType() {
        return Affix.class;
    }

    public static void classload() {
    }

    public String toString() {
        return String.format("Affix: %s", this.name);
    }

    public abstract boolean canApply(EquipmentType var1);

    public abstract float getMin();

    public abstract float getMax();

    public float upgradeLevel(float curLvl, float newLvl) {
        return Math.min(this.getMax(), newLvl > curLvl ? newLvl + curLvl / 2.0f : newLvl / 2.0f + curLvl);
    }

    public float obliterateLevel(float level) {
        return Math.max(this.getMin(), level / 2.0f);
    }

    public static IFormattableTextComponent loreComponent(String text, Object ... args) {
        return new TranslationTextComponent(text, args).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.DARK_PURPLE});
    }

    public static String fmt(float f) {
        if (f == (float)((long)f)) {
            return String.format("%d", (long)f);
        }
        return String.format("%.2f", Float.valueOf(f));
    }

    public ITextComponent getDisplayName(float level) {
        return new TranslationTextComponent("affix." + this.getRegistryName() + ".name", new Object[]{Affix.fmt(level)}).func_240699_a_(TextFormatting.GRAY);
    }

    static {
        RegistryBuilder build = new RegistryBuilder();
        build.setName(new ResourceLocation("apotheosis", "affixes"));
        build.setType(Affix.class);
        REGISTRY = (ForgeRegistry)build.create();
    }
}

