/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import shadows.apotheosis.spawn.modifiers.SpawnerStat;
import shadows.apotheosis.spawn.modifiers.SpawnerStats;
import shadows.apotheosis.spawn.modifiers.StatModifier;
import shadows.apotheosis.spawn.spawner.ApothSpawnerTile;

public class SpawnerModifier
implements IRecipe<IInventory> {
    public static final IRecipeType<SpawnerModifier> TYPE = IRecipeType.func_222147_a((String)"apotheosis:spawner_modifier");
    public static final Serializer SERIALIZER = new Serializer();
    protected final ResourceLocation id;
    protected final Ingredient mainHand;
    protected final Ingredient offHand;
    protected final boolean consumesOffhand;
    protected final List<StatModifier<?>> statChanges;

    public SpawnerModifier(ResourceLocation id, Ingredient mainHand, Ingredient offHand, boolean consumesOffhand, List<StatModifier<?>> stats) {
        this.id = id;
        this.mainHand = mainHand;
        this.offHand = offHand;
        this.consumesOffhand = consumesOffhand;
        this.statChanges = ImmutableList.copyOf(stats);
    }

    public boolean matches(ApothSpawnerTile tile, ItemStack mainhand, ItemStack offhand) {
        if (this.mainHand.test(mainhand)) {
            if (this.offHand == Ingredient.field_193370_a) {
                return true;
            }
            return this.offHand.test(offhand);
        }
        return false;
    }

    public boolean apply(ApothSpawnerTile tile) {
        boolean success = false;
        for (StatModifier<?> m : this.statChanges) {
            if (!m.apply(tile)) continue;
            success = true;
        }
        return success;
    }

    public boolean consumesOffhand() {
        return this.consumesOffhand;
    }

    public Ingredient getMainhandInput() {
        return this.mainHand;
    }

    public Ingredient getOffhandInput() {
        return this.offHand;
    }

    public List<StatModifier<?>> getStatModifiers() {
        return this.statChanges;
    }

    @Deprecated
    public boolean func_77569_a(IInventory pContainer, World pLevel) {
        return false;
    }

    @Deprecated
    public ItemStack func_77572_b(IInventory pContainer) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public boolean func_194133_a(int pWidth, int pHeight) {
        return false;
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    @Nullable
    public static SpawnerModifier findMatch(ApothSpawnerTile tile, ItemStack mainhand, ItemStack offhand) {
        List recipes = tile.func_145831_w().func_199532_z().func_241447_a_(TYPE);
        recipes.sort((r1, r2) -> r1.offHand == Ingredient.field_193370_a ? (r2.offHand == Ingredient.field_193370_a ? 0 : 1) : -1);
        for (SpawnerModifier r : recipes) {
            if (!r.matches(tile, mainhand, offhand)) continue;
            return r;
        }
        return null;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SpawnerModifier> {
        public SpawnerModifier fromJson(ResourceLocation id, JsonObject obj) {
            Ingredient mainhand = Ingredient.func_199802_a((JsonElement)obj.get("mainhand"));
            Ingredient offhand = obj.has("offhand") ? Ingredient.func_199802_a((JsonElement)obj.get("offhand")) : Ingredient.field_193370_a;
            JsonArray stats = obj.get("stat_changes").getAsJsonArray();
            ArrayList statChanges = new ArrayList();
            for (JsonElement e : stats) {
                statChanges.add(StatModifier.parse(e.getAsJsonObject()));
            }
            return new SpawnerModifier(id, mainhand, offhand, offhand == Ingredient.field_193370_a ? false : obj.get("consumes_offhand").getAsBoolean(), statChanges);
        }

        public SpawnerModifier fromNetwork(ResourceLocation id, PacketBuffer buf) {
            Ingredient mainhand = Ingredient.func_199566_b((PacketBuffer)buf);
            Ingredient offhand = buf.readBoolean() ? Ingredient.func_199566_b((PacketBuffer)buf) : Ingredient.field_193370_a;
            boolean consumesOffhand = buf.readBoolean();
            ArrayList statChanges = new ArrayList();
            int size = buf.readByte();
            for (int i = 0; i < size; ++i) {
                SpawnerStat<?> stat = SpawnerStats.REGISTRY.get(buf.func_150789_c(32));
                boolean isBool = buf.readBoolean();
                if (isBool) {
                    statChanges.add(new StatModifier<Boolean>(stat, buf.readBoolean(), false, false));
                    continue;
                }
                statChanges.add(new StatModifier<Integer>(stat, buf.readInt(), buf.readInt(), buf.readInt()));
            }
            return new SpawnerModifier(id, mainhand, offhand, consumesOffhand, statChanges);
        }

        public void toNetwork(PacketBuffer buf, SpawnerModifier recipe) {
            recipe.mainHand.func_199564_a(buf);
            buf.writeBoolean(recipe.offHand != Ingredient.field_193370_a);
            if (recipe.offHand != Ingredient.field_193370_a) {
                recipe.offHand.func_199564_a(buf);
            }
            buf.writeBoolean(recipe.consumesOffhand);
            buf.writeByte(recipe.statChanges.size());
            for (StatModifier<?> s : recipe.statChanges) {
                SpawnerStat stat = s.stat;
                buf.func_211400_a(stat.getId(), 32);
                boolean isBool = stat.getTypeClass() == Boolean.class;
                buf.writeBoolean(isBool);
                if (isBool) {
                    buf.writeBoolean(((Boolean)s.value).booleanValue());
                    continue;
                }
                buf.writeInt(((Integer)s.value).intValue());
                buf.writeInt(((Integer)s.min).intValue());
                buf.writeInt(((Integer)s.max).intValue());
            }
        }
    }
}

