/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.spawn.SpawnerModuleClient;
import shadows.apotheosis.spawn.compat.SpawnerTOPPlugin;
import shadows.apotheosis.spawn.enchantment.CapturingEnchant;
import shadows.apotheosis.spawn.modifiers.SpawnerModifier;
import shadows.apotheosis.spawn.spawner.ApothSpawnerBlock;
import shadows.apotheosis.spawn.spawner.ApothSpawnerItem;
import shadows.apotheosis.spawn.spawner.ApothSpawnerTile;
import shadows.placebo.config.Configuration;
import shadows.placebo.util.PlaceboUtil;

public class SpawnerModule {
    public static final Logger LOG = LogManager.getLogger((String)"Apotheosis : Spawner");
    public static int spawnerSilkLevel = 1;
    public static int spawnerSilkDamage = 100;
    public static Set<ResourceLocation> bannedMobs = new HashSet<ResourceLocation>();

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        TileEntityType.field_200979_j.field_200995_z = ApothSpawnerTile::new;
        TileEntityType.field_200979_j.field_223046_I = ImmutableSet.of((Object)Blocks.field_150474_ac);
        MinecraftForge.EVENT_BUS.addListener(this::handleCapturing);
        MinecraftForge.EVENT_BUS.addListener(this::handleUseItem);
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        MinecraftForge.EVENT_BUS.addListener(this::tickDumbMobs);
        this.reload(null);
        if (ModList.get().isLoaded("theoneprobe")) {
            SpawnerTOPPlugin.register();
        }
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        ApothSpawnerBlock spawner = new ApothSpawnerBlock();
        PlaceboUtil.overrideStates((Block)Blocks.field_150474_ac, (Block)spawner);
        e.getRegistry().register((IForgeRegistryEntry)spawner);
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().register((IForgeRegistryEntry)new ApothSpawnerItem());
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        e.getRegistry().register(SpawnerModifier.SERIALIZER.setRegistryName("spawner_modifier"));
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().register(new CapturingEnchant().setRegistryName("apotheosis", "capturing"));
    }

    @SubscribeEvent
    public void client(FMLClientSetupEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new SpawnerModuleClient());
    }

    public void handleCapturing(LivingDropsEvent e) {
        Entity killer = e.getSource().func_76346_g();
        if (killer instanceof LivingEntity) {
            int level = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.CAPTURING, (ItemStack)((LivingEntity)killer).func_184614_ca());
            LivingEntity killed = e.getEntityLiving();
            if (bannedMobs.contains(killed.func_200600_R().getRegistryName())) {
                return;
            }
            if (killed.field_70170_p.field_73012_v.nextFloat() < (float)level / 250.0f) {
                ItemStack egg = new ItemStack((IItemProvider)ForgeSpawnEggItem.fromEntityType((EntityType)killed.func_200600_R()));
                e.getDrops().add(new ItemEntity(killed.field_70170_p, killed.func_226277_ct_(), killed.func_226278_cu_(), killed.func_226281_cx_(), egg));
            }
        }
    }

    public void handleUseItem(PlayerInteractEvent.RightClickBlock e) {
        SpawnEggItem egg;
        EntityType type;
        ItemStack s;
        if (e.getWorld().func_175625_s(e.getPos()) instanceof ApothSpawnerTile && (s = e.getItemStack()).func_77973_b() instanceof SpawnEggItem && bannedMobs.contains((type = (egg = (SpawnEggItem)s.func_77973_b()).func_208076_b(s.func_77978_p())).getRegistryName())) {
            e.setCanceled(true);
        }
    }

    public void tickDumbMobs(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntityLiving() instanceof MobEntity) {
            MobEntity mob = (MobEntity)e.getEntityLiving();
            if (!mob.field_70170_p.field_72995_K && mob.func_175446_cd() && mob.getPersistentData().func_74767_n("apotheosis:movable")) {
                mob.func_94061_f(false);
                mob.func_213352_e(new Vector3d((double)mob.field_70702_br, (double)mob.field_191988_bg, (double)mob.field_70701_bs));
                mob.func_94061_f(true);
            }
        }
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        String[] bans;
        Configuration config = new Configuration(new File(Apotheosis.configDir, "spawner.cfg"));
        spawnerSilkLevel = config.getInt("Spawner Silk Level", "general", 1, -1, 127, "The level of silk touch needed to harvest a spawner.  Set to -1 to disable, 0 to always drop.  The enchantment module can increase the max level of silk touch.");
        spawnerSilkDamage = config.getInt("Spawner Silk Damage", "general", 100, 0, 100000, "The durability damage dealt to an item that silk touches a spawner.");
        bannedMobs.clear();
        for (String s : bans = config.getStringList("Banned Mobs", "spawn_eggs", new String[0], "A list of entity registry names that cannot be applied to spawners via egg.")) {
            try {
                bannedMobs.add(new ResourceLocation(s));
            }
            catch (ResourceLocationException ex) {
                LOG.error("Invalid entry {} detected in the spawner banned mobs list.", (Object)s);
                ex.printStackTrace();
            }
        }
        if (e == null && config.hasChanged()) {
            config.save();
        }
    }
}

