/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.potion.compat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Size2i;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.compat.EnchantingCategory;
import shadows.apotheosis.potion.PotionCharmItem;
import shadows.apotheosis.potion.PotionCharmRecipe;
import shadows.apotheosis.potion.PotionEnchantingRecipe;

@JeiPlugin
public class PotionJEIPlugin
implements IModPlugin {
    ICraftingGridHelper gridHelper;

    public void registerRecipes(IRecipeRegistration reg) {
        if (!Apotheosis.enablePotion) {
            return;
        }
        this.gridHelper = reg.getJeiHelpers().getGuiHelper().createCraftingGridHelper(1);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration reg) {
        if (!Apotheosis.enablePotion) {
            return;
        }
        reg.getCraftingCategory().addCategoryExtension(PotionCharmRecipe.class, x$0 -> new PotionCharmRecipeWrapper((PotionCharmRecipe)((Object)x$0)));
        EnchantingCategory.registerExtension(PotionEnchantingRecipe.class, new PotionCharmEnchantingWrapper());
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        if (!Apotheosis.enablePotion) {
            return;
        }
        reg.registerSubtypeInterpreter((Item)ApotheosisObjects.POTION_CHARM, (IIngredientSubtypeInterpreter)new PotionCharmSubtypes());
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("apotheosis", "potion");
    }

    private class PotionCharmSubtypes
    implements IIngredientSubtypeInterpreter<ItemStack> {
        private PotionCharmSubtypes() {
        }

        public String apply(ItemStack stack, UidContext context) {
            if (context != UidContext.Recipe) {
                if (!PotionCharmItem.hasPotion(stack)) {
                    return "";
                }
                Potion p = PotionUtils.func_185191_c((ItemStack)stack);
                EffectInstance contained = (EffectInstance)p.func_185170_a().get(0);
                return contained.func_188419_a().getRegistryName() + "@" + contained.func_76458_c() + "@" + contained.func_76459_b();
            }
            return "";
        }
    }

    private class PotionCharmEnchantingWrapper
    implements EnchantingCategory.Extension<PotionEnchantingRecipe> {
        private PotionCharmEnchantingWrapper() {
        }

        @Override
        public void setIngredients(PotionEnchantingRecipe recipe, IIngredients ing) {
            ing.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
            ing.setInputIngredients(Arrays.asList(recipe.getInput()));
        }

        @Override
        public void setRecipe(PotionEnchantingRecipe recipe, IRecipeLayout recipeLayout, IIngredients ingredients) {
            IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
            IFocus fcs = recipeLayout.getFocus(VanillaTypes.ITEM);
            ItemStack focus = fcs == null ? ItemStack.field_190927_a : (ItemStack)recipeLayout.getFocus(VanillaTypes.ITEM).getValue();
            Potion potion = PotionUtils.func_185191_c((ItemStack)focus) == Potions.field_185229_a ? Potions.field_185245_q : PotionUtils.func_185191_c((ItemStack)focus);
            ItemStack output = new ItemStack((IItemProvider)ApotheosisObjects.POTION_CHARM);
            PotionUtils.func_185188_a((ItemStack)output, (Potion)potion);
            ItemStack input = output.func_77946_l();
            output.func_196082_o().func_74757_a("Unbreakable", true);
            stacks.set(1, output);
            stacks.set(0, input);
        }
    }

    private class PotionCharmRecipeWrapper
    implements ICustomCraftingCategoryExtension {
        private final PotionCharmRecipe recipe;

        PotionCharmRecipeWrapper(PotionCharmRecipe recipe) {
            this.recipe = recipe;
        }

        public void setIngredients(IIngredients ingredients) {
            ingredients.setInputIngredients((List)this.recipe.func_192400_c());
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.recipe.func_77571_b());
        }

        public ResourceLocation getRegistryName() {
            return this.recipe.func_199560_c();
        }

        public Size2i getSize() {
            return new Size2i(3, 3);
        }

        public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            IFocus fcs = recipeLayout.getFocus(VanillaTypes.ITEM);
            ItemStack focus = fcs == null ? ItemStack.field_190927_a : (ItemStack)recipeLayout.getFocus(VanillaTypes.ITEM).getValue();
            Potion potion = PotionUtils.func_185191_c((ItemStack)focus) == Potions.field_185229_a ? Potions.field_185245_q : PotionUtils.func_185191_c((ItemStack)focus);
            List recipeInputs = ingredients.getInputs(VanillaTypes.ITEM);
            ArrayList clones = new ArrayList();
            recipeInputs.forEach(l -> {
                ArrayList cloneList = new ArrayList();
                l.stream().map(ItemStack::func_77946_l).map(s -> s.func_77942_o() && s.func_77978_p().func_74764_b("Potion") ? PotionUtils.func_185188_a((ItemStack)s, (Potion)potion) : s).forEach(cloneList::add);
                clones.add(cloneList);
            });
            ItemStack output = new ItemStack((IItemProvider)ApotheosisObjects.POTION_CHARM);
            PotionUtils.func_185188_a((ItemStack)output, (Potion)potion);
            Size2i size = this.getSize();
            PotionJEIPlugin.this.gridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, clones, size.width, size.height);
            guiItemStacks.set(0, output);
        }
    }
}

