/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.objects.IEnchantingBlock;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.SerializerBuilder;

public class EnchantingStatManager
extends PlaceboJsonReloadListener<BlockStats> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final EnchantingStatManager INSTANCE = new EnchantingStatManager();
    private final Map<Block, Stats> statsPerBlock = new HashMap<Block, Stats>();
    private float absoluteMaxEterna = 50.0f;

    protected EnchantingStatManager() {
        super(EnchModule.LOGGER, "enchanting_stats", true, false);
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, new SerializerBuilder("Enchanting Stats").withJsonDeserializer(obj -> {
            Stats stats = (Stats)GSON.fromJson(obj.get("stats"), Stats.class);
            ArrayList<Block> blocks = new ArrayList<Block>();
            if (obj.has("blocks")) {
                for (JsonElement e : obj.get("blocks").getAsJsonArray()) {
                    Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(e.getAsString()));
                    blocks.add(b);
                }
            } else {
                Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(obj.get("block").getAsString()));
                blocks.add(b);
            }
            return new BlockStats(blocks, stats);
        }).withNetworkSerializer((stats, buf) -> {
            buf.writeInt(stats.blocks.size());
            stats.blocks.forEach(b -> buf.writeInt(Registry.field_212618_g.func_148757_b(b)));
            stats.stats.write(buf);
        }).withNetworkDeserializer(buf -> {
            int size = buf.readInt();
            ArrayList<Block> blocks = new ArrayList<Block>();
            for (int i = 0; i < size; ++i) {
                blocks.add((Block)Registry.field_212618_g.func_148745_a(buf.readInt()));
            }
            return new BlockStats(blocks, Stats.read(buf));
        }));
    }

    protected void beginReload() {
        super.beginReload();
        this.statsPerBlock.clear();
    }

    protected void onReload() {
        super.onReload();
        for (BlockStats bStats : this.registry.values()) {
            bStats.blocks.forEach(b -> this.statsPerBlock.put((Block)b, bStats.stats));
        }
        this.computeAbsoluteMaxEterna();
    }

    public static float getEterna(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatManager.INSTANCE.statsPerBlock.get((Object)block).eterna;
        }
        return state.getEnchantPowerBonus((IWorldReader)world, pos);
    }

    public static float getMaxEterna(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatManager.INSTANCE.statsPerBlock.get((Object)block).maxEterna;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getMaxEnchantingPower(state, (IWorldReader)world, pos);
        }
        return 15.0f;
    }

    public static float getQuanta(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatManager.INSTANCE.statsPerBlock.get((Object)block).quanta;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getQuantaBonus(state, (IWorldReader)world, pos);
        }
        return 0.0f;
    }

    public static float getArcana(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatManager.INSTANCE.statsPerBlock.get((Object)block).arcana;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getArcanaBonus(state, (IWorldReader)world, pos);
        }
        return 0.0f;
    }

    public static float getQuantaRectification(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatManager.INSTANCE.statsPerBlock.get((Object)block).rectification;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getQuantaRectification(state, (IWorldReader)world, pos);
        }
        return 0.0f;
    }

    public static int getBonusClues(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (EnchantingStatManager.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatManager.INSTANCE.statsPerBlock.get((Object)block).clues;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getBonusClues(state, (IWorldReader)world, pos);
        }
        return 0;
    }

    public static float getAbsoluteMaxEterna() {
        return EnchantingStatManager.INSTANCE.absoluteMaxEterna;
    }

    private void computeAbsoluteMaxEterna() {
        this.absoluteMaxEterna = this.registry.values().stream().max(Comparator.comparingDouble((ToDoubleFunction<BlockStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$computeAbsoluteMaxEterna$5(shadows.apotheosis.ench.table.EnchantingStatManager$BlockStats ), (Lshadows/apotheosis/ench/table/EnchantingStatManager$BlockStats;)D)())).get().stats.maxEterna;
    }

    private static /* synthetic */ double lambda$computeAbsoluteMaxEterna$5(BlockStats s) {
        return s.stats.maxEterna;
    }

    public static class BlockStats
    extends PlaceboJsonReloadListener.TypeKeyedBase<BlockStats> {
        public final List<Block> blocks;
        public final Stats stats;

        public BlockStats(List<Block> blocks, Stats stats) {
            this.blocks = blocks;
            this.stats = stats;
        }
    }

    public static class Stats {
        public final float maxEterna;
        public final float eterna;
        public final float quanta;
        public final float arcana;
        public final float rectification;
        public final int clues;

        public Stats(float maxEterna, float eterna, float quanta, float arcana, float rectification, int clues) {
            this.maxEterna = maxEterna;
            this.eterna = eterna;
            this.quanta = quanta;
            this.arcana = arcana;
            this.rectification = rectification;
            this.clues = clues;
        }

        public void write(PacketBuffer buf) {
            buf.writeFloat(this.maxEterna);
            buf.writeFloat(this.eterna);
            buf.writeFloat(this.quanta);
            buf.writeFloat(this.arcana);
            buf.writeFloat(this.rectification);
            buf.writeByte(this.clues);
        }

        public static Stats read(PacketBuffer buf) {
            return new Stats(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readByte());
        }
    }
}

