/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import shadows.apotheosis.ench.table.EnchantingStatManager;

public class EnchantingRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<EnchantingRecipe> TYPE = IRecipeType.func_222147_a((String)"apotheosis:enchanting");
    public static final Serializer SERIALIZER = new Serializer();
    public static final EnchantingStatManager.Stats NO_MAX = new EnchantingStatManager.Stats(-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1);
    protected final ResourceLocation id;
    protected final ItemStack output;
    protected final Ingredient input;
    protected final EnchantingStatManager.Stats requirements;
    protected final EnchantingStatManager.Stats maxRequirements;

    public EnchantingRecipe(ResourceLocation id, ItemStack output, Ingredient input, EnchantingStatManager.Stats requirements, EnchantingStatManager.Stats maxRequirements) {
        this.id = id;
        this.output = output;
        this.input = input;
        this.requirements = requirements;
        this.maxRequirements = maxRequirements;
    }

    public boolean matches(ItemStack input, float eterna, float quanta, float arcana) {
        if (this.maxRequirements.eterna > -1.0f && eterna > this.maxRequirements.eterna || this.maxRequirements.quanta > -1.0f && quanta > this.maxRequirements.quanta || this.maxRequirements.arcana > -1.0f && arcana > this.maxRequirements.arcana) {
            return false;
        }
        return this.input.test(input) && eterna >= this.requirements.eterna && quanta >= this.requirements.quanta && arcana >= this.requirements.arcana;
    }

    public EnchantingStatManager.Stats getRequirements() {
        return this.requirements;
    }

    public EnchantingStatManager.Stats getMaxRequirements() {
        return this.maxRequirements;
    }

    public Ingredient getInput() {
        return this.input;
    }

    @Deprecated
    public boolean func_77569_a(IInventory pInv, World pLevel) {
        return false;
    }

    @Deprecated
    public ItemStack func_77572_b(IInventory pContainer) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public boolean func_194133_a(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack assemble(ItemStack input, float eterna, float quanta, float arcana) {
        return this.func_77571_b().func_77946_l();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    @Nullable
    public static EnchantingRecipe findMatch(World level, ItemStack input, float eterna, float quanta, float arcana) {
        List recipes = level.func_199532_z().func_241447_a_(TYPE);
        recipes.sort((r1, r2) -> -Float.compare(r1.requirements.eterna, r2.requirements.eterna));
        for (EnchantingRecipe r : recipes) {
            if (!r.matches(input, eterna, quanta, arcana)) continue;
            return r;
        }
        return null;
    }

    public static EnchantingRecipe findItemMatch(World level, ItemStack toEnchant) {
        return level.func_199532_z().func_241447_a_(TYPE).stream().filter(r -> r.getInput().test(toEnchant)).findFirst().orElse(null);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<EnchantingRecipe> {
        protected static final Gson GSON = new GsonBuilder().create();

        public EnchantingRecipe fromJson(ResourceLocation id, JsonObject obj) {
            EnchantingStatManager.Stats maxStats;
            ItemStack output = CraftingHelper.getItemStack((JsonObject)obj.get("result").getAsJsonObject(), (boolean)true);
            Ingredient input = Ingredient.func_199802_a((JsonElement)obj.get("input"));
            EnchantingStatManager.Stats stats = (EnchantingStatManager.Stats)GSON.fromJson(obj.get("requirements"), EnchantingStatManager.Stats.class);
            EnchantingStatManager.Stats stats2 = maxStats = obj.has("max_requirements") ? (EnchantingStatManager.Stats)GSON.fromJson(obj.get("max_requirements"), EnchantingStatManager.Stats.class) : NO_MAX;
            if (output.func_190926_b()) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid empty output item.");
            }
            if (maxStats.eterna != -1.0f && stats.eterna > maxStats.eterna) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max eterna bounds (min > max).");
            }
            if (maxStats.quanta != -1.0f && stats.quanta > maxStats.quanta) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max quanta bounds (min > max).");
            }
            if (maxStats.arcana != -1.0f && stats.arcana > maxStats.arcana) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max arcana bounds (min > max).");
            }
            return new EnchantingRecipe(id, output, input, stats, maxStats);
        }

        public EnchantingRecipe fromNetwork(ResourceLocation id, PacketBuffer buf) {
            ItemStack output = buf.func_150791_c();
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buf);
            EnchantingStatManager.Stats stats = EnchantingStatManager.Stats.read(buf);
            EnchantingStatManager.Stats maxStats = buf.readBoolean() ? EnchantingStatManager.Stats.read(buf) : NO_MAX;
            return new EnchantingRecipe(id, output, input, stats, maxStats);
        }

        public void toNetwork(PacketBuffer buf, EnchantingRecipe recipe) {
            buf.func_150788_a(recipe.output);
            recipe.input.func_199564_a(buf);
            recipe.requirements.write(buf);
            buf.writeBoolean(recipe.maxRequirements != NO_MAX);
            if (recipe.maxRequirements != NO_MAX) {
                recipe.maxRequirements.write(buf);
            }
        }
    }
}

