/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.network.NetworkEvent;
import shadows.apotheosis.ench.table.ApothEnchantScreen;
import shadows.placebo.util.NetworkUtils;

public class ClueMessage
extends NetworkUtils.MessageProvider<ClueMessage> {
    protected final int slot;
    protected final List<EnchantmentData> clues;
    protected final boolean all;

    public ClueMessage(int slot, List<EnchantmentData> clues, boolean all) {
        this.slot = slot;
        this.clues = clues;
        this.all = all;
    }

    public void write(ClueMessage msg, PacketBuffer buf) {
        buf.writeByte(msg.clues.size());
        for (EnchantmentData e : msg.clues) {
            buf.writeShort(Registry.field_212628_q.func_148757_b((Object)e.field_76302_b));
            buf.writeByte(e.field_76303_c);
        }
        buf.writeByte(msg.slot);
        buf.writeBoolean(msg.all);
    }

    public ClueMessage read(PacketBuffer buf) {
        int size = buf.readByte();
        ArrayList<EnchantmentData> clues = new ArrayList<EnchantmentData>(size);
        for (int i = 0; i < size; ++i) {
            Enchantment ench = (Enchantment)Registry.field_212628_q.func_148745_a((int)buf.readShort());
            clues.add(new EnchantmentData(ench, (int)buf.readByte()));
        }
        return new ClueMessage(buf.readByte(), clues, buf.readBoolean());
    }

    public void handle(ClueMessage msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkUtils.handlePacket(() -> () -> {
            if (Minecraft.func_71410_x().field_71462_r instanceof ApothEnchantScreen) {
                ((ApothEnchantScreen)Minecraft.func_71410_x().field_71462_r).acceptClues(msg.slot, msg.clues, msg.all);
            }
        }, (NetworkEvent.Context)ctx.get());
    }
}

