/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.library;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.apotheosis.ench.library.EnchLibraryContainer;
import shadows.apotheosis.ench.library.EnchLibraryTile;
import shadows.placebo.Placebo;
import shadows.placebo.net.MessageButtonClick;

public class EnchLibraryScreen
extends ContainerScreen<EnchLibraryContainer> {
    public static final ResourceLocation TEXTURES = new ResourceLocation("apotheosis", "textures/gui/library.png");
    protected float scrollOffs;
    protected boolean scrolling;
    protected int startIndex;
    protected List<LibrarySlot> data = new ArrayList<LibrarySlot>();
    private static DecimalFormat f = new DecimalFormat("##.#");

    public EnchLibraryScreen(EnchLibraryContainer container, PlayerInventory inv, ITextComponent title) {
        super((Container)container, inv, title);
        this.field_146999_f = 176;
        this.field_230708_k_ = 176;
        this.field_147000_g = 241;
        this.field_230709_l_ = 241;
        this.field_238744_r_ = 7;
        this.field_238742_p_ = 7;
        this.field_238743_q_ = 4;
        this.field_238745_s_ = 149;
        this.containerChanged();
        container.setNotifier(this::containerChanged);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    protected void func_230459_a_(MatrixStack stack, int mouseX, int mouseY) {
        super.func_230459_a_(stack, mouseX, mouseY);
        LibrarySlot libSlot = this.getHoveredSlot(mouseX, mouseY);
        if (libSlot != null) {
            int targetLevel;
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new TranslationTextComponent(libSlot.ench.func_77320_a()).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0xFFFF80)).setUnderlined(Boolean.valueOf(true))));
            list.add(new TranslationTextComponent("tooltip.enchlib.max_lvl", new Object[]{new TranslationTextComponent("enchantment.level." + libSlot.maxLvl)}).func_240699_a_(TextFormatting.GRAY));
            list.add(new TranslationTextComponent("tooltip.enchlib.points", new Object[]{EnchLibraryScreen.format(libSlot.points), EnchLibraryScreen.format(((EnchLibraryContainer)this.field_147002_h).getPointCap())}).func_240699_a_(TextFormatting.GRAY));
            list.add(new StringTextComponent(""));
            ItemStack outSlot = ((EnchLibraryContainer)this.field_147002_h).ioInv.func_70301_a(1);
            int current = EnchantmentHelper.func_82781_a((ItemStack)outSlot).getOrDefault(libSlot.ench, 0);
            boolean shift = Screen.func_231173_s_();
            int n = targetLevel = shift ? Math.min(libSlot.maxLvl, 1 + (int)(Math.log(libSlot.points + EnchLibraryTile.levelToPoints(current)) / Math.log(2.0))) : current + 1;
            if (targetLevel == current) {
                ++targetLevel;
            }
            int cost = EnchLibraryTile.levelToPoints(targetLevel) - EnchLibraryTile.levelToPoints(current);
            if (targetLevel > libSlot.maxLvl) {
                list.add(new TranslationTextComponent("tooltip.enchlib.unavailable").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)));
            } else {
                list.add(new TranslationTextComponent("tooltip.enchlib.extracting", new Object[]{new TranslationTextComponent("enchantment.level." + targetLevel)}).func_240699_a_(TextFormatting.BLUE));
                list.add(new TranslationTextComponent("tooltip.enchlib.cost", new Object[]{cost}).func_240699_a_(cost > libSlot.points ? TextFormatting.RED : TextFormatting.GOLD));
            }
            this.renderWrappedToolTip(stack, list, this.getGuiLeft() - 16 - this.field_230712_o_.func_238414_a_((ITextProperties)list.get(2)), mouseY, this.field_230712_o_);
        }
    }

    protected void func_230450_a_(MatrixStack stack, float partial, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURES);
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        this.func_238474_b_(stack, left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        int scrollbarPos = (int)(118.0f * this.scrollOffs);
        this.func_238474_b_(stack, left + 75, top + 14 + scrollbarPos, 244, this.isScrollBarActive() ? 0 : 15, 12, 15);
        for (int idx = this.startIndex; idx < this.startIndex + 7 && idx < this.data.size(); ++idx) {
            this.renderEntry(stack, this.data.get(idx), this.field_147003_i + 8, this.field_147009_r + 14 + 19 * (idx - this.startIndex), mouseX, mouseY);
        }
    }

    private void renderEntry(MatrixStack stack, LibrarySlot data, int x, int y, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURES);
        boolean hover = this.func_195359_a(x - this.field_147003_i, y - this.field_147009_r, 64, 17, mouseX, mouseY);
        this.func_238474_b_(stack, x, y, 178, hover ? 19 : 0, 64, 19);
        int progress = (int)Math.round(62.0 * Math.sqrt(data.points) / (double)((float)Math.sqrt(((EnchLibraryContainer)this.field_147002_h).getPointCap())));
        this.func_238474_b_(stack, x + 1, y + 12, 179, 38, progress, 5);
        stack.func_227860_a_();
        TranslationTextComponent txt = new TranslationTextComponent(data.ench.func_77320_a());
        float scale = 1.0f;
        if (this.field_230712_o_.func_238414_a_((ITextProperties)txt) > 60) {
            scale = 60.0f / (float)this.field_230712_o_.func_238414_a_((ITextProperties)txt);
        }
        stack.func_227862_a_(scale, scale, 1.0f);
        this.field_230712_o_.func_243248_b(stack, (ITextComponent)txt, (float)(x + 2) / scale, (float)(y + 2) / scale, 0xFFFF80);
        stack.func_227865_b_();
    }

    public boolean func_231044_a_(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        int left = this.field_147003_i + 52;
        int top = this.field_147009_r + 14;
        LibrarySlot libSlot = this.getHoveredSlot((int)pMouseX, (int)pMouseY);
        if (libSlot != null) {
            int id = ((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)libSlot.ench);
            if (Screen.func_231173_s_()) {
                id |= Integer.MIN_VALUE;
            }
            ((EnchLibraryContainer)this.field_147002_h).onButtonClick(id);
            Placebo.CHANNEL.sendToServer((Object)new MessageButtonClick(id));
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
        }
        left = this.field_147003_i + 75;
        top = this.field_147009_r + 9;
        if (pMouseX >= (double)left && pMouseX < (double)(left + 12) && pMouseY >= (double)top && pMouseY < (double)(top + 131)) {
            this.scrolling = true;
        }
        return super.func_231044_a_(pMouseX, pMouseY, pButton);
    }

    public boolean func_231045_a_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.field_147009_r + 14;
            int j = i + 131;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = MathHelper.func_76131_a((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.func_231045_a_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean func_231043_a_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)i);
            this.scrollOffs = MathHelper.func_76131_a((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.data.size() > 7;
    }

    protected int getOffscreenRows() {
        return this.data.size() - 7;
    }

    private void containerChanged() {
        this.data.clear();
        for (Object2IntMap.Entry<Enchantment> e : ((EnchLibraryContainer)this.field_147002_h).getPointsForDisplay()) {
            this.data.add(new LibrarySlot((Enchantment)e.getKey(), e.getIntValue(), ((EnchLibraryContainer)this.field_147002_h).getMaxLevel((Enchantment)e.getKey())));
        }
        if (!this.isScrollBarActive()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        Collections.sort(this.data, (a, b) -> I18n.func_135052_a((String)a.ench.func_77320_a(), (Object[])new Object[0]).compareTo(I18n.func_135052_a((String)b.ench.func_77320_a(), (Object[])new Object[0])));
    }

    @Nullable
    public LibrarySlot getHoveredSlot(int mouseX, int mouseY) {
        for (int i = 0; i < 7; ++i) {
            if (this.startIndex + i >= this.data.size() || !this.func_195359_a(8, 14 + 19 * i, 64, 17, mouseX, mouseY)) continue;
            return this.data.get(this.startIndex + i);
        }
        return null;
    }

    public static String format(int n) {
        int log = (int)StrictMath.log10(n);
        if (log <= 4) {
            return String.valueOf(n);
        }
        if (log == 5) {
            return f.format((double)n / 1000.0) + "K";
        }
        if (log <= 8) {
            return f.format((double)n / 1000000.0) + "M";
        }
        return f.format((double)n / 1.0E9) + "B";
    }

    private static class LibrarySlot {
        protected final Enchantment ench;
        protected final int points;
        protected final int maxLvl;

        private LibrarySlot(Enchantment ench, int points, int maxLvl) {
            this.ench = ench;
            this.points = points;
            this.maxLvl = maxLvl;
        }
    }
}

