/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.enchantments;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingHealEvent;

public class LifeMendingEnchant
extends Enchantment {
    private static final EquipmentSlotType[] SLOTS = EquipmentSlotType.values();

    public LifeMendingEnchant() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentType.BREAKABLE, EquipmentSlotType.values());
    }

    public int func_77321_a(int level) {
        return 60 + level * 20;
    }

    public int func_223551_b(int level) {
        return this.func_77321_a(level) + 50;
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_190936_d() {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return super.canApplyAtEnchantingTable(stack) || stack.func_77973_b().isShield(stack, null);
    }

    public ITextComponent func_200305_d(int level) {
        return ((IFormattableTextComponent)super.func_200305_d(level)).func_240699_a_(TextFormatting.DARK_RED);
    }

    public void lifeMend(LivingHealEvent e) {
        if (e.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        float amt = e.getAmount();
        if (amt <= 0.0f) {
            return;
        }
        for (EquipmentSlotType slot : SLOTS) {
            int level;
            ItemStack stack = e.getEntityLiving().func_184582_a(slot);
            if (stack.func_190926_b() || !stack.func_77951_h() || (level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack)) <= 0) continue;
            float cost = 1.0f / (float)(1 << level - 1);
            int maxRestore = Math.min(MathHelper.func_76141_d((float)(amt / cost)), stack.func_77952_i());
            e.setAmount(e.getAmount() - (float)maxRestore * cost);
            stack.func_196085_b(stack.func_77952_i() - maxRestore);
            return;
        }
    }
}

