/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench;

import java.math.BigDecimal;
import net.minecraft.enchantment.Enchantment;
import s_com.udojava.evalex.Expression;
import shadows.apotheosis.ench.EnchModule;

public class EnchantmentInfo {
    final Enchantment ench;
    final int maxLevel;
    final int minLevel;
    PowerFunc maxPower;
    PowerFunc minPower;

    public EnchantmentInfo(Enchantment ench, int maxLevel, int minLevel) {
        this.ench = ench;
        this.maxLevel = maxLevel;
        this.minLevel = minLevel;
        this.maxPower = EnchantmentInfo.defaultMax(ench);
        this.minPower = EnchantmentInfo.defaultMin(ench);
    }

    public int getMaxLevel() {
        return Math.min(EnchModule.ENCH_HARD_CAPS.getOrDefault((Object)this.ench, Integer.MAX_VALUE), this.maxLevel);
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMinPower(int level) {
        return this.minPower.getPower(level);
    }

    public int getMaxPower(int level) {
        return this.maxPower.getPower(level);
    }

    public void setMaxPower(PowerFunc maxPower) {
        this.maxPower = maxPower;
    }

    public void setMinPower(PowerFunc minPower) {
        this.minPower = minPower;
    }

    private static PowerFunc defaultMax(Enchantment ench) {
        return level -> 200;
    }

    private static PowerFunc defaultMin(Enchantment ench) {
        return level -> {
            if (level > 1) {
                int diff = ench.func_77321_a(ench.func_77325_b()) - ench.func_77321_a(ench.func_77325_b() - 1);
                return level > ench.func_77325_b() ? ench.func_77321_a(level) + diff * (int)Math.pow(level - ench.func_77325_b(), 1.6) : ench.func_77321_a(level);
            }
            return ench.func_77321_a(level);
        };
    }

    public static class ExpressionPowerFunc
    implements PowerFunc {
        Expression ex;

        public ExpressionPowerFunc(String func) {
            this.ex = new Expression(func);
        }

        @Override
        public int getPower(int level) {
            return this.ex.setVariable("x", new BigDecimal(level)).eval().intValue();
        }
    }

    public static interface PowerFunc {
        public int getPower(int var1);
    }
}

